/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.query.QueryImpl;

public class QueryManagerImpl
implements QueryManager {
    private final Session session;
    private final ManagerProvider mgrProvider;
    private final ItemManager itemMgr;
    private final WorkspaceManager wspManager;

    public QueryManagerImpl(Session session, ManagerProvider mgrProvider, ItemManager itemMgr, WorkspaceManager wspManager) {
        this.session = session;
        this.mgrProvider = mgrProvider;
        this.itemMgr = itemMgr;
        this.wspManager = wspManager;
    }

    public Query createQuery(String statement, String language) throws InvalidQueryException, RepositoryException {
        this.checkIsAlive();
        return new QueryImpl(this.session, this.mgrProvider, this.itemMgr, this.wspManager, statement, language);
    }

    public Query getQuery(Node node) throws InvalidQueryException, RepositoryException {
        this.checkIsAlive();
        return new QueryImpl(this.session, this.mgrProvider, this.itemMgr, this.wspManager, node);
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        return this.wspManager.getSupportedQueryLanguages();
    }

    private void checkIsAlive() throws RepositoryException {
        if (!this.session.isLive()) {
            throw new RepositoryException("corresponding session has been closed");
        }
    }
}

