/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;

class RowIteratorImpl
implements RowIterator {
    private final RangeIterator rows;
    private final Name[] columnNames;
    private final NamePathResolver resolver;
    private final ValueFactory vFactory;

    RowIteratorImpl(QueryInfo queryInfo, NamePathResolver resolver, ValueFactory vFactory) {
        this.rows = queryInfo.getRows();
        this.columnNames = queryInfo.getColumnNames();
        this.resolver = resolver;
        this.vFactory = vFactory;
    }

    public Row nextRow() throws NoSuchElementException {
        return new RowImpl((QueryResultRow)this.rows.next());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.rows.skip(skipNum);
    }

    public long getSize() {
        return this.rows.getSize();
    }

    public long getPosition() {
        return this.rows.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.rows.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final QueryResultRow row;
        private Value[] values;
        private Map propertyMap;

        private RowImpl(QueryResultRow row) {
            this.row = row;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                QValue[] qVals = this.row.getValues();
                Value[] tmp = new Value[qVals.length];
                for (int i = 0; i < qVals.length; ++i) {
                    tmp[i] = qVals[i] == null ? null : ValueFormat.getJCRValue((QValue)qVals[i], (NamePathResolver)RowIteratorImpl.this.resolver, (ValueFactory)RowIteratorImpl.this.vFactory);
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            if (this.propertyMap == null) {
                HashMap<Name, Integer> tmp = new HashMap<Name, Integer>();
                for (int i = 0; i < RowIteratorImpl.this.columnNames.length; ++i) {
                    tmp.put(RowIteratorImpl.this.columnNames[i], new Integer(i));
                }
                this.propertyMap = tmp;
            }
            try {
                Name prop = RowIteratorImpl.this.resolver.getQName(propertyName);
                Integer idx = (Integer)this.propertyMap.get(prop);
                if (idx == null) {
                    throw new ItemNotFoundException(propertyName);
                }
                if (this.values == null) {
                    this.getValues();
                }
                return this.values[idx];
            }
            catch (NameException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

