/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLog {
    private static final Logger log = LoggerFactory.getLogger((Class)ChangeLog.class);
    private final ItemState target;
    private final Set operations;
    private final Set affectedStates;

    ChangeLog(ItemState target, Set operations, Set affectedStates) throws InvalidItemStateException, ConstraintViolationException {
        this.target = target;
        this.operations = operations;
        this.affectedStates = affectedStates;
    }

    public void persisted() throws RepositoryException {
        ArrayList<NodeState> changedMixins = new ArrayList<NodeState>();
        Operation[] ops = this.operations.toArray(new Operation[this.operations.size()]);
        for (int i = 0; i < ops.length; ++i) {
            ops[i].persisted();
            if (!(ops[i] instanceof SetMixin)) continue;
            changedMixins.add(((SetMixin)ops[i]).getNodeState());
        }
        Iterator it = this.affectedStates.iterator();
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            HierarchyEntry he = state.getHierarchyEntry();
            switch (state.getStatus()) {
                case 2: {
                    state.setStatus(1);
                    if (!state.isNode() || !changedMixins.contains(state)) break;
                    he.invalidate(false);
                    break;
                }
                case 3: {
                    he.remove();
                    break;
                }
                case 4: {
                    log.error("ChangeLog still contains NEW state: " + state.getName());
                    state.setStatus(1);
                    break;
                }
                case -1: 
                case 5: 
                case 6: 
                case 7: {
                    log.error("ChangeLog contains state (" + state.getName() + ") with illegal status " + Status.getName(state.getStatus()));
                    break;
                }
                case 1: {
                    if (!state.isNode() || !changedMixins.contains(state)) break;
                    he.invalidate(false);
                    break;
                }
            }
        }
    }

    public void undo() throws RepositoryException {
        Operation[] ops = this.operations.toArray(new Operation[this.operations.size()]);
        for (int i = ops.length - 1; i >= 0; --i) {
            ops[i].undo();
        }
        Iterator it = this.affectedStates.iterator();
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            switch (state.getStatus()) {
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    state.getHierarchyEntry().revert();
                    break;
                }
                case 4: {
                    log.error("ChangeLog still contains NEW state: " + state.getName());
                    state.getHierarchyEntry().revert();
                    break;
                }
                case -1: 
                case 7: {
                    log.error("ChangeLog contains state (" + state.getName() + ") with illegal status " + Status.getName(state.getStatus()));
                    break;
                }
            }
        }
    }

    public ItemState getTarget() {
        return this.target;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public Set getOperations() {
        return this.operations;
    }

    public Set getAffectedStates() {
        return this.affectedStates;
    }

    void reset() {
        this.affectedStates.clear();
        this.operations.clear();
    }
}

