/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStateValidator {
    private static Logger log = LoggerFactory.getLogger((Class)ItemStateValidator.class);
    public static final int CHECK_ACCESS = 1;
    public static final int CHECK_LOCK = 2;
    public static final int CHECK_VERSIONING = 4;
    public static final int CHECK_CONSTRAINTS = 8;
    public static final int CHECK_COLLISION = 32;
    public static final int CHECK_NONE = 0;
    public static final int CHECK_ALL = 47;
    private final ManagerProvider mgrProvider;
    private final PathFactory pathFactory;

    public ItemStateValidator(ManagerProvider mgrProvider, PathFactory pathFactory) {
        this.mgrProvider = mgrProvider;
        this.pathFactory = pathFactory;
    }

    public void validate(NodeState nodeState) throws ConstraintViolationException, RepositoryException {
        EffectiveNodeType entPrimary = this.mgrProvider.getEffectiveNodeTypeProvider().getEffectiveNodeType(nodeState.getNodeTypeName());
        QNodeDefinition def = nodeState.getDefinition();
        Name[] requiredPrimaryTypes = def.getRequiredPrimaryTypes();
        for (int i = 0; i < requiredPrimaryTypes.length; ++i) {
            if (entPrimary.includesNodeType(requiredPrimaryTypes[i])) continue;
            String msg = this.safeGetJCRPath(nodeState) + ": missing required primary type " + requiredPrimaryTypes[i];
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        Name[] ntNames = nodeState.getAllNodeTypeNames();
        EffectiveNodeType entPrimaryAndMixins = this.mgrProvider.getEffectiveNodeTypeProvider().getEffectiveNodeType(ntNames);
        QPropertyDefinition[] pda = entPrimaryAndMixins.getMandatoryQPropertyDefinitions();
        for (int i = 0; i < pda.length; ++i) {
            QPropertyDefinition pd = pda[i];
            if (nodeState.hasPropertyName(pd.getName())) continue;
            String msg = this.safeGetJCRPath(nodeState) + ": mandatory property " + pd.getName() + " does not exist";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        QNodeDefinition[] cnda = entPrimaryAndMixins.getMandatoryQNodeDefinitions();
        for (int i = 0; i < cnda.length; ++i) {
            QNodeDefinition cnd = cnda[i];
            if (nodeState.getNodeEntry().hasNodeEntry(cnd.getName())) continue;
            String msg = this.safeGetJCRPath(nodeState) + ": mandatory child node " + cnd.getName() + " does not exist";
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
    }

    private String safeGetJCRPath(ItemState itemState) {
        return LogUtil.safeGetJCRPath(itemState, this.mgrProvider.getPathResolver());
    }

    public void checkIsWritable(NodeState parentState, int options) throws VersionException, LockException, ItemNotFoundException, ItemExistsException, PathNotFoundException, RepositoryException {
        if ((options & 1) == 1 && !this.mgrProvider.getAccessManager().canRead(parentState)) {
            throw new ItemNotFoundException(this.safeGetJCRPath(parentState));
        }
        if ((options & 2) == 2) {
            this.checkLock(parentState);
        }
        if ((options & 4) == 4) {
            this.checkIsCheckedOut(parentState);
        }
        if ((options & 8) == 8) {
            this.checkProtection(parentState);
        }
    }

    public void checkSetProperty(PropertyState propState, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ItemExistsException, PathNotFoundException, RepositoryException {
        NodeState parent = propState.getParent();
        QPropertyDefinition def = propState.getDefinition();
        this.checkWriteProperty(parent, propState.getName(), def, options);
    }

    public void checkAddProperty(NodeState parentState, Name propertyName, QPropertyDefinition definition, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ItemExistsException, PathNotFoundException, RepositoryException {
        this.checkWriteProperty(parentState, propertyName, definition, options);
    }

    private void checkWriteProperty(NodeState parentState, Name propertyName, QPropertyDefinition definition, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ItemExistsException, PathNotFoundException, RepositoryException {
        this.checkIsWritable(parentState, options);
        if ((options & 1) == 1) {
            Path relPath = this.pathFactory.create(propertyName);
            if (!this.mgrProvider.getAccessManager().isGranted(parentState, relPath, new String[]{"set_property"})) {
                throw new AccessDeniedException(this.safeGetJCRPath(parentState) + ": not allowed to create property with name " + propertyName);
            }
        }
        if ((options & 8) == 8) {
            this.checkProtection((QItemDefinition)definition);
        }
        if ((options & 0x20) == 32) {
            this.checkCollision(parentState, propertyName);
        }
    }

    public void checkAddNode(NodeState parentState, Name nodeName, Name nodeTypeName, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ItemExistsException, RepositoryException {
        this.checkIsWritable(parentState, options);
        if ((options & 1) == 1) {
            Path relPath = this.pathFactory.create(nodeName);
            if (!this.mgrProvider.getAccessManager().isGranted(parentState, relPath, new String[]{"add_node"})) {
                throw new AccessDeniedException(this.safeGetJCRPath(parentState) + ": not allowed to add child node '" + nodeName + "'");
            }
        }
        if ((options & 8) == 8) {
            Name[] ntNames = parentState.getAllNodeTypeNames();
            EffectiveNodeType entParent = this.mgrProvider.getEffectiveNodeTypeProvider().getEffectiveNodeType(ntNames);
            entParent.checkAddNodeConstraints(nodeName, nodeTypeName, this.mgrProvider.getItemDefinitionProvider());
        }
        if ((options & 0x20) == 32) {
            this.checkCollision(parentState, nodeName, nodeTypeName);
        }
    }

    public void checkRemoveItem(ItemState targetState, int options) throws ConstraintViolationException, AccessDeniedException, VersionException, LockException, ItemNotFoundException, ReferentialIntegrityException, RepositoryException {
        if (targetState.isNode() && ((NodeState)targetState).isRoot()) {
            throw new ConstraintViolationException("Cannot remove root node.");
        }
        this.checkIsWritable(targetState.getParent(), options);
        if ((options & 1) == 1) {
            try {
                if (!this.mgrProvider.getAccessManager().canRemove(targetState)) {
                    throw new AccessDeniedException(this.safeGetJCRPath(targetState) + ": not allowed to remove node");
                }
            }
            catch (ItemNotFoundException e) {
                String msg = "internal error: failed to check access rights for " + this.safeGetJCRPath(targetState);
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
        if ((options & 8) == 8) {
            this.checkRemoveConstraints(targetState);
        }
    }

    private void checkIsCheckedOut(ItemState itemState) throws PathNotFoundException, VersionException, RepositoryException {
        NodeState nodeState = itemState.isNode() ? (NodeState)itemState : itemState.getParent();
        this.mgrProvider.getVersionManager().checkIsCheckedOut(nodeState);
    }

    private void checkLock(ItemState itemState) throws LockException, RepositoryException {
        NodeState nodeState = itemState.isNode() ? (NodeState)itemState : itemState.getParent();
        this.mgrProvider.getLockManager().checkLock(nodeState);
    }

    private void checkProtection(ItemState itemState) throws ConstraintViolationException, RepositoryException {
        Object def = itemState.isNode() ? ((NodeState)itemState).getDefinition() : ((PropertyState)itemState).getDefinition();
        this.checkProtection((QItemDefinition)def);
    }

    private void checkProtection(QItemDefinition definition) throws ConstraintViolationException {
        if (definition.isProtected()) {
            throw new ConstraintViolationException("Item is protected");
        }
    }

    private void checkRemoveConstraints(ItemState itemState) throws ConstraintViolationException, RepositoryException {
        Object definition = itemState.isNode() ? ((NodeState)itemState).getDefinition() : ((PropertyState)itemState).getDefinition();
        this.checkProtection((QItemDefinition)definition);
    }

    private void checkCollision(NodeState parentState, Name propertyName) throws ItemExistsException, RepositoryException {
        NodeEntry parentEntry = (NodeEntry)parentState.getHierarchyEntry();
        if (parentEntry.hasNodeEntry(propertyName)) {
            String msg = "Child node with name '" + propertyName + "' already exists.";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        PropertyEntry pe = parentEntry.getPropertyEntry(propertyName);
        if (pe != null) {
            try {
                pe.getPropertyState();
                throw new ItemExistsException("Property '" + pe.getName() + "' already exists.");
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
    }

    private void checkCollision(NodeState parentState, Name nodeName, Name nodeTypeName) throws RepositoryException, ConstraintViolationException, NoSuchNodeTypeException {
        if (parentState.hasPropertyName(nodeName)) {
            throw new ItemExistsException("cannot add child node '" + nodeName.getLocalName() + "' to " + this.safeGetJCRPath(parentState) + ": colliding with same-named existing property");
        }
        if (parentState.hasChildNodeEntry(nodeName, 1)) {
            try {
                NodeState conflictingState = parentState.getChildNodeState(nodeName, 1);
                QNodeDefinition conflictDef = conflictingState.getDefinition();
                QNodeDefinition newDef = this.mgrProvider.getItemDefinitionProvider().getQNodeDefinition(parentState.getAllNodeTypeNames(), nodeName, nodeTypeName);
                if (!conflictDef.allowsSameNameSiblings() || !newDef.allowsSameNameSiblings()) {
                    throw new ItemExistsException("Cannot add child node '" + nodeName.getLocalName() + "' to " + this.safeGetJCRPath(parentState) + ": colliding with same-named existing node.");
                }
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
    }
}

