/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.operation.AddLabel;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.AddProperty;
import org.apache.jackrabbit.jcr2spi.operation.Checkin;
import org.apache.jackrabbit.jcr2spi.operation.Checkout;
import org.apache.jackrabbit.jcr2spi.operation.Clone;
import org.apache.jackrabbit.jcr2spi.operation.Copy;
import org.apache.jackrabbit.jcr2spi.operation.LockOperation;
import org.apache.jackrabbit.jcr2spi.operation.LockRefresh;
import org.apache.jackrabbit.jcr2spi.operation.LockRelease;
import org.apache.jackrabbit.jcr2spi.operation.Merge;
import org.apache.jackrabbit.jcr2spi.operation.Move;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.operation.Remove;
import org.apache.jackrabbit.jcr2spi.operation.RemoveLabel;
import org.apache.jackrabbit.jcr2spi.operation.RemoveVersion;
import org.apache.jackrabbit.jcr2spi.operation.ReorderNodes;
import org.apache.jackrabbit.jcr2spi.operation.ResolveMergeConflict;
import org.apache.jackrabbit.jcr2spi.operation.Restore;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.SetPropertyValue;
import org.apache.jackrabbit.jcr2spi.operation.Update;
import org.apache.jackrabbit.jcr2spi.operation.WorkspaceImport;
import org.apache.jackrabbit.jcr2spi.state.ChangeLog;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.ItemStateValidator;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateManager;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.jcr2spi.util.ReferenceChangeTracker;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionItemStateManager
implements UpdatableItemStateManager,
OperationVisitor {
    private static Logger log = LoggerFactory.getLogger((Class)SessionItemStateManager.class);
    private final UpdatableItemStateManager workspaceItemStateMgr;
    private final TransientItemStateManager transientStateMgr;
    private final ItemStateValidator validator;
    private final QValueFactory qValueFactory;
    private final ManagerProvider mgrProvider;

    public SessionItemStateManager(UpdatableItemStateManager workspaceItemStateMgr, ItemStateValidator validator, QValueFactory qValueFactory, ItemStateFactory isf, ManagerProvider mgrProvider) {
        this.workspaceItemStateMgr = workspaceItemStateMgr;
        this.transientStateMgr = new TransientItemStateManager();
        isf.addCreationListener(this.transientStateMgr);
        this.validator = validator;
        this.qValueFactory = qValueFactory;
        this.mgrProvider = mgrProvider;
    }

    public boolean hasPendingChanges() {
        return this.transientStateMgr.hasPendingChanges();
    }

    public void save(ItemState state) throws ReferentialIntegrityException, InvalidItemStateException, RepositoryException {
        if (!this.transientStateMgr.hasPendingChanges()) {
            return;
        }
        ChangeLog changeLog = this.transientStateMgr.getChangeLog(state, true);
        if (!changeLog.isEmpty()) {
            this.workspaceItemStateMgr.execute(changeLog);
            this.transientStateMgr.dispose(changeLog);
            changeLog.reset();
        }
    }

    public void undo(ItemState itemState) throws ConstraintViolationException, RepositoryException {
        if (!this.transientStateMgr.hasPendingChanges()) {
            return;
        }
        ChangeLog changeLog = this.transientStateMgr.getChangeLog(itemState, false);
        if (!changeLog.isEmpty()) {
            changeLog.undo();
            this.transientStateMgr.dispose(changeLog);
            changeLog.reset();
        }
    }

    public void adjustReferences(ReferenceChangeTracker refTracker) throws ConstraintViolationException, RepositoryException {
        Iterator it = refTracker.getReferences();
        while (it.hasNext()) {
            PropertyState propState = (PropertyState)it.next();
            boolean modified = false;
            QValue[] values = propState.getValues();
            QValue[] newVals = new QValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                QValue val = values[i];
                QValue adjusted = refTracker.getMappedReference(val, this.qValueFactory);
                if (adjusted != null) {
                    newVals[i] = adjusted;
                    modified = true;
                    continue;
                }
                newVals[i] = val;
            }
            if (!modified) continue;
            int options = 14;
            this.setPropertyStateValue(propState, newVals, 9, options);
        }
        refTracker.clear();
    }

    public void execute(Operation operation) throws RepositoryException {
        operation.accept(this);
    }

    public void execute(ChangeLog changes) throws RepositoryException {
        throw new UnsupportedOperationException("Not implemented for SessionItemStateManager");
    }

    public void dispose() {
        this.transientStateMgr.dispose();
        this.workspaceItemStateMgr.dispose();
    }

    public void visit(AddNode operation) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        int options = 46;
        NodeState parent = operation.getParentState();
        ItemDefinitionProvider defProvider = this.mgrProvider.getItemDefinitionProvider();
        QNodeDefinition def = defProvider.getQNodeDefinition(parent.getAllNodeTypeNames(), operation.getNodeName(), operation.getNodeTypeName());
        List newStates = this.addNodeState(parent, operation.getNodeName(), operation.getNodeTypeName(), operation.getUuid(), def, options);
        operation.addedState(newStates);
        this.transientStateMgr.addOperation(operation);
    }

    public void visit(AddProperty operation) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        NodeState parent = operation.getParentState();
        Name propertyName = operation.getPropertyName();
        QPropertyDefinition pDef = operation.getDefinition();
        int targetType = pDef.getRequiredType();
        if (targetType == 0 && (targetType = operation.getPropertyType()) == 0) {
            targetType = 1;
        }
        int options = 46;
        this.addPropertyState(parent, propertyName, targetType, operation.getValues(), pDef, options);
        this.transientStateMgr.addOperation(operation);
    }

    public void visit(Move operation) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        NodeState srcState = operation.getSourceState();
        NodeState srcParent = operation.getSourceParentState();
        NodeState destParent = operation.getDestinationParentState();
        this.validator.checkRemoveItem(srcState, 15);
        this.validator.checkAddNode(destParent, operation.getDestinationName(), srcState.getNodeTypeName(), 15);
        ItemDefinitionProvider defProvider = this.mgrProvider.getItemDefinitionProvider();
        QNodeDefinition newDefinition = defProvider.getQNodeDefinition(destParent.getAllNodeTypeNames(), operation.getDestinationName(), srcState.getNodeTypeName());
        srcParent.moveChildNodeEntry(destParent, srcState, operation.getDestinationName(), newDefinition);
        this.transientStateMgr.addOperation(operation);
    }

    public void visit(Remove operation) throws ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        ItemState state = operation.getRemoveState();
        int options = 14;
        this.removeItemState(state, options);
        this.transientStateMgr.addOperation(operation);
        operation.getParentState().markModified();
    }

    public void visit(SetMixin operation) throws ConstraintViolationException, AccessDeniedException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        Name[] mixinNames = operation.getMixinNames();
        NodeState nState = operation.getNodeState();
        NodeEntry nEntry = nState.getNodeEntry();
        PropertyEntry mixinEntry = nEntry.getPropertyEntry(NameConstants.JCR_MIXINTYPES);
        if (mixinNames.length > 0) {
            if (mixinEntry != null) {
                PropertyState pState = mixinEntry.getPropertyState();
                int options = 6;
                this.setPropertyStateValue(pState, SessionItemStateManager.getQValues(mixinNames, this.qValueFactory), 7, options);
            } else {
                ItemDefinitionProvider defProvider = this.mgrProvider.getItemDefinitionProvider();
                QPropertyDefinition pd = defProvider.getQPropertyDefinition(nState.getAllNodeTypeNames(), NameConstants.JCR_MIXINTYPES, 7, true);
                QValue[] mixinValue = SessionItemStateManager.getQValues(mixinNames, this.qValueFactory);
                int options = 6;
                this.addPropertyState(nState, pd.getName(), pd.getRequiredType(), mixinValue, pd, options);
            }
            nState.markModified();
            this.transientStateMgr.addOperation(operation);
        } else if (mixinEntry != null) {
            PropertyState pState = mixinEntry.getPropertyState();
            boolean newMixinState = pState.getStatus() == 4;
            int options = 6;
            this.removeItemState(pState, options);
            nState.markModified();
            this.transientStateMgr.addOperation(operation);
        }
    }

    public void visit(SetPropertyValue operation) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        PropertyState pState = operation.getPropertyState();
        int options = 14;
        this.setPropertyStateValue(pState, operation.getValues(), operation.getValueType(), options);
        this.transientStateMgr.addOperation(operation);
    }

    public void visit(ReorderNodes operation) throws ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        NodeState parent = operation.getParentState();
        parent.reorderChildNodeEntries(operation.getInsertNode(), operation.getBeforeNode());
        this.transientStateMgr.addOperation(operation);
    }

    public void visit(Clone operation) throws NoSuchWorkspaceException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: Clone cannot be handled by session ItemStateManager.");
    }

    public void visit(Copy operation) throws NoSuchWorkspaceException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: Copy cannot be handled by session ItemStateManager.");
    }

    public void visit(Checkout operation) throws RepositoryException, UnsupportedRepositoryOperationException {
        throw new UnsupportedOperationException("Internal error: Checkout cannot be handled by session ItemStateManager.");
    }

    public void visit(Checkin operation) throws UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: Checkin cannot be handled by session ItemStateManager.");
    }

    public void visit(Update operation) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: Update cannot be handled by session ItemStateManager.");
    }

    public void visit(Restore operation) throws VersionException, PathNotFoundException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: Restore cannot be handled by session ItemStateManager.");
    }

    public void visit(Merge operation) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: Merge cannot be handled by session ItemStateManager.");
    }

    public void visit(ResolveMergeConflict operation) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: Update cannot be handled by session ItemStateManager.");
    }

    public void visit(LockOperation operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: Lock cannot be handled by session ItemStateManager.");
    }

    public void visit(LockRefresh operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: LockRefresh cannot be handled by session ItemStateManager.");
    }

    public void visit(LockRelease operation) throws AccessDeniedException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: LockRelease cannot be handled by session ItemStateManager.");
    }

    public void visit(AddLabel operation) throws VersionException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: AddLabel cannot be handled by session ItemStateManager.");
    }

    public void visit(RemoveLabel operation) throws VersionException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: RemoveLabel cannot be handled by session ItemStateManager.");
    }

    public void visit(RemoveVersion operation) throws VersionException, AccessDeniedException, ReferentialIntegrityException, RepositoryException {
        throw new UnsupportedOperationException("Internal error: RemoveVersion cannot be handled by session ItemStateManager.");
    }

    public void visit(WorkspaceImport operation) throws RepositoryException {
        throw new UnsupportedOperationException("Internal error: WorkspaceImport cannot be handled by session ItemStateManager.");
    }

    private PropertyState addPropertyState(NodeState parent, Name propertyName, int propertyType, QValue[] values, QPropertyDefinition pDef, int options) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        this.validator.checkAddProperty(parent, propertyName, pDef, options);
        return this.transientStateMgr.createNewPropertyState(propertyName, parent, pDef, values, propertyType);
    }

    private List addNodeState(NodeState parent, Name nodeName, Name nodeTypeName, String uuid, QNodeDefinition definition, int options) throws RepositoryException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchNodeTypeException, ItemExistsException, VersionException {
        this.validator.checkAddNode(parent, nodeName, nodeTypeName, options);
        EffectiveNodeType ent = this.mgrProvider.getEffectiveNodeTypeProvider().getEffectiveNodeType(nodeTypeName);
        if (nodeTypeName == null && (nodeTypeName = definition.getDefaultPrimaryType()) == null) {
            String msg = "an applicable node type could not be determined for " + nodeName;
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        ArrayList<ItemState> addedStates = new ArrayList<ItemState>();
        NodeState nodeState = this.transientStateMgr.createNewNodeState(nodeName, null, nodeTypeName, definition, parent);
        addedStates.add(nodeState);
        if (uuid != null) {
            QValue[] value = SessionItemStateManager.getQValues(uuid, this.qValueFactory);
            ItemDefinitionProvider defProvider = this.mgrProvider.getItemDefinitionProvider();
            QPropertyDefinition pDef = defProvider.getQPropertyDefinition(NameConstants.MIX_REFERENCEABLE, NameConstants.JCR_UUID, 1, false);
            addedStates.add(this.addPropertyState(nodeState, NameConstants.JCR_UUID, 1, value, pDef, 0));
        }
        QPropertyDefinition[] pda = ent.getAutoCreateQPropertyDefinitions();
        for (int i = 0; i < pda.length; ++i) {
            QValue[] autoValue;
            QPropertyDefinition pd = pda[i];
            if (nodeState.hasPropertyName(pd.getName()) || (autoValue = this.computeSystemGeneratedPropertyValues(nodeState, pd)) == null) continue;
            int propOptions = 0;
            addedStates.add(this.addPropertyState(nodeState, pd.getName(), pd.getRequiredType(), autoValue, pd, propOptions));
        }
        QNodeDefinition[] nda = ent.getAutoCreateQNodeDefinitions();
        for (int i = 0; i < nda.length; ++i) {
            QNodeDefinition nd = nda[i];
            int opt = 34;
            addedStates.addAll(this.addNodeState(nodeState, nd.getName(), nd.getDefaultPrimaryType(), null, nd, opt));
        }
        return addedStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItemState(ItemState itemState, int options) throws RepositoryException {
        this.validator.checkRemoveItem(itemState, options);
        boolean success = false;
        try {
            itemState.getHierarchyEntry().transientRemove();
            success = true;
        }
        finally {
            if (!success) {
                // empty if block
            }
        }
    }

    private void setPropertyStateValue(PropertyState propState, QValue[] iva, int valueType, int options) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        this.validator.checkSetProperty(propState, options);
        propState.setValues(iva, valueType);
    }

    private QValue[] computeSystemGeneratedPropertyValues(NodeState parent, QPropertyDefinition def) throws RepositoryException {
        QValue[] genValues = null;
        QValue[] qDefaultValues = def.getDefaultValues();
        if (qDefaultValues != null && qDefaultValues.length > 0) {
            genValues = qDefaultValues;
        } else if (def.isAutoCreated()) {
            Name declaringNT = def.getDeclaringNodeType();
            Name name = def.getName();
            if (NameConstants.NT_BASE.equals(declaringNT) && NameConstants.JCR_PRIMARYTYPE.equals(name)) {
                genValues = new QValue[]{this.qValueFactory.create(parent.getNodeTypeName())};
            } else if (NameConstants.NT_BASE.equals(declaringNT) && NameConstants.JCR_MIXINTYPES.equals(name)) {
                Name[] mixins = parent.getMixinTypeNames();
                genValues = SessionItemStateManager.getQValues(mixins, this.qValueFactory);
            } else {
                genValues = this.qValueFactory.computeAutoValues(def);
            }
        }
        return genValues;
    }

    private static QValue[] getQValues(Name[] qNames, QValueFactory factory) throws RepositoryException {
        QValue[] ret = new QValue[qNames.length];
        for (int i = 0; i < qNames.length; ++i) {
            ret[i] = factory.create(qNames[i]);
        }
        return ret;
    }

    private static QValue[] getQValues(String uniqueID, QValueFactory factory) throws RepositoryException {
        return new QValue[]{factory.create(uniqueID, 1)};
    }
}

