/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.state.AbstractItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceItemStateFactory
extends AbstractItemStateFactory
implements ItemStateFactory {
    private static Logger log = LoggerFactory.getLogger((Class)WorkspaceItemStateFactory.class);
    private final RepositoryService service;
    private final SessionInfo sessionInfo;
    private final ItemDefinitionProvider definitionProvider;

    public WorkspaceItemStateFactory(RepositoryService service, SessionInfo sessionInfo, ItemDefinitionProvider definitionProvider) {
        this.service = service;
        this.sessionInfo = sessionInfo;
        this.definitionProvider = definitionProvider;
    }

    public NodeState createRootState(NodeEntry entry) throws ItemNotFoundException, RepositoryException {
        IdFactory idFactory = this.service.getIdFactory();
        PathFactory pf = this.service.getPathFactory();
        return this.createNodeState(idFactory.createNodeId((String)null, pf.getRootPath()), entry);
    }

    public NodeState createNodeState(NodeId nodeId, NodeEntry entry) throws ItemNotFoundException, RepositoryException {
        try {
            Iterator infos = this.service.getItemInfos(this.sessionInfo, nodeId);
            NodeState nodeState = this.createItemStates(nodeId, infos, entry, false);
            if (nodeState == null) {
                throw new ItemNotFoundException("HierarchyEntry does not belong to any existing ItemInfo.");
            }
            return nodeState;
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    public NodeState createDeepNodeState(NodeId nodeId, NodeEntry anyParent) throws ItemNotFoundException, RepositoryException {
        try {
            Iterator infos = this.service.getItemInfos(this.sessionInfo, nodeId);
            return this.createItemStates(nodeId, infos, anyParent, true);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    public PropertyState createPropertyState(PropertyId propertyId, PropertyEntry entry) throws ItemNotFoundException, RepositoryException {
        try {
            PropertyInfo info = this.service.getPropertyInfo(this.sessionInfo, propertyId);
            WorkspaceItemStateFactory.assertMatchingPath((ItemInfo)info, entry);
            return this.createPropertyState(info, entry);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    public PropertyState createDeepPropertyState(PropertyId propertyId, NodeEntry anyParent) throws ItemNotFoundException, RepositoryException {
        try {
            PropertyInfo info = this.service.getPropertyInfo(this.sessionInfo, propertyId);
            PropertyState propState = this.createDeepPropertyState(info, anyParent, null);
            WorkspaceItemStateFactory.assertValidState(propState, (ItemInfo)info);
            return propState;
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    public Iterator getChildNodeInfos(NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        return this.service.getChildInfos(this.sessionInfo, nodeId);
    }

    public PropertyId[] getNodeReferences(NodeState nodeState) {
        NodeEntry entry = nodeState.getNodeEntry();
        if (entry.getUniqueID() == null || !entry.hasPropertyEntry(NameConstants.JCR_UUID)) {
            return new PropertyId[0];
        }
        try {
            NodeInfo nInfo = this.service.getNodeInfo(this.sessionInfo, entry.getWorkspaceId());
            return nInfo.getReferences();
        }
        catch (RepositoryException e) {
            log.debug("Unable to determine references to {}", (Object)nodeState);
            return new PropertyId[0];
        }
    }

    private synchronized NodeState createItemStates(NodeId nodeId, Iterator itemInfos, NodeEntry entry, boolean isDeep) throws ItemNotFoundException, RepositoryException {
        NodeState nodeState;
        ItemInfos infos = new ItemInfos(itemInfos);
        if (infos.hasNext()) {
            NodeInfo first = (NodeInfo)infos.next();
            if (isDeep) {
                nodeState = this.createDeepNodeState(first, entry, infos);
                WorkspaceItemStateFactory.assertValidState(nodeState, (ItemInfo)first);
            } else {
                WorkspaceItemStateFactory.assertMatchingPath((ItemInfo)first, entry);
                nodeState = this.createNodeState(first, entry);
            }
        } else {
            throw new ItemNotFoundException("Node with id " + nodeId + " could not be found.");
        }
        NodeEntry approxParentEntry = nodeState.getNodeEntry();
        while (infos.hasNext()) {
            ItemInfo info = (ItemInfo)infos.next();
            if (info.denotesNode()) {
                approxParentEntry = this.createDeepNodeState((NodeInfo)info, approxParentEntry, infos).getNodeEntry();
                continue;
            }
            this.createDeepPropertyState((PropertyInfo)info, approxParentEntry, infos);
        }
        return nodeState;
    }

    private NodeState createNodeState(NodeInfo info, NodeEntry entry) throws ItemNotFoundException, RepositoryException {
        String uniqueID = info.getId().getUniqueID();
        Path path = info.getId().getPath();
        if (path == null) {
            entry.setUniqueID(uniqueID);
        } else if (uniqueID != null) {
            NodeEntry parent = WorkspaceItemStateFactory.getAncestor(entry, path.getLength());
            parent.setUniqueID(uniqueID);
        }
        int previousStatus = entry.getStatus();
        if (Status.isTransient(previousStatus) || Status.isStale(previousStatus)) {
            log.debug("Node has pending changes; omit resetting the state.");
            return entry.getNodeState();
        }
        ArrayList<Name> propNames = new ArrayList<Name>();
        Iterator it = info.getPropertyIds();
        while (it.hasNext()) {
            PropertyId pId = (PropertyId)it.next();
            Name propertyName = pId.getName();
            propNames.add(propertyName);
        }
        try {
            entry.setPropertyEntries(propNames);
        }
        catch (ItemExistsException e) {
            log.warn("Internal error", (Throwable)e);
        }
        Iterator childInfos = info.getChildInfos();
        if (childInfos != null) {
            entry.setNodeEntries(childInfos);
        }
        NodeState tmp = new NodeState(entry, info, (ItemStateFactory)this, this.definitionProvider);
        entry.setItemState(tmp);
        NodeState nState = entry.getNodeState();
        if (previousStatus == -1) {
            this.notifyCreated(nState);
        } else {
            this.notifyUpdated(nState, previousStatus);
        }
        return nState;
    }

    private PropertyState createPropertyState(PropertyInfo info, PropertyEntry entry) throws RepositoryException {
        int previousStatus;
        String uniqueID = info.getId().getUniqueID();
        if (uniqueID != null) {
            NodeEntry parent = WorkspaceItemStateFactory.getAncestor(entry, info.getId().getPath().getLength());
            parent.setUniqueID(uniqueID);
        }
        if (Status.isTransient(previousStatus = entry.getStatus()) || Status.isStale(previousStatus)) {
            log.debug("Property has pending changes; omit resetting the state.");
            return entry.getPropertyState();
        }
        PropertyState tmp = new PropertyState(entry, info, (ItemStateFactory)this, this.definitionProvider);
        entry.setItemState(tmp);
        PropertyState pState = entry.getPropertyState();
        if (previousStatus == -1) {
            this.notifyCreated(pState);
        } else {
            this.notifyUpdated(pState, previousStatus);
        }
        return pState;
    }

    private NodeState createDeepNodeState(NodeInfo info, NodeEntry anyParent, ItemInfos infos) throws RepositoryException {
        try {
            Path anyParentPath = anyParent.getWorkspacePath();
            Path relPath = anyParentPath.computeRelativePath(info.getPath());
            Path.Element[] missingElems = relPath.getElements();
            if (WorkspaceItemStateFactory.startsWithIllegalElement(missingElems)) {
                log.error("Relative path to NodeEntry starts with illegal element -> ignore NodeInfo with path " + info.getPath());
                return null;
            }
            NodeEntry entry = anyParent;
            for (int i = 0; i < missingElems.length; ++i) {
                if (missingElems[i].denotesParent()) {
                    entry = entry.getParent();
                    continue;
                }
                if (!missingElems[i].denotesName()) continue;
                Name name = missingElems[i].getName();
                int index = missingElems[i].getNormalizedIndex();
                entry = WorkspaceItemStateFactory.createIntermediateNodeEntry(entry, name, index, infos);
            }
            if (entry == anyParent) {
                throw new RepositoryException("Internal error while getting deep itemState");
            }
            return this.createNodeState(info, entry);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    private PropertyState createDeepPropertyState(PropertyInfo info, NodeEntry anyParent, ItemInfos infos) throws RepositoryException {
        try {
            int i;
            Path anyParentPath = anyParent.getWorkspacePath();
            Path relPath = anyParentPath.computeRelativePath(info.getPath());
            Path.Element[] missingElems = relPath.getElements();
            if (WorkspaceItemStateFactory.startsWithIllegalElement(missingElems)) {
                log.error("Relative path to PropertyEntry starts with illegal element -> ignore PropertyInfo with path " + info.getPath());
                return null;
            }
            NodeEntry entry = anyParent;
            for (i = 0; i < missingElems.length - 1; ++i) {
                if (missingElems[i].denotesParent()) {
                    entry = entry.getParent();
                    continue;
                }
                if (!missingElems[i].denotesName()) continue;
                Name name = missingElems[i].getName();
                int index = missingElems[i].getNormalizedIndex();
                entry = WorkspaceItemStateFactory.createIntermediateNodeEntry(entry, name, index, infos);
            }
            Name propName = missingElems[i].getName();
            PropertyEntry propEntry = entry.getOrAddPropertyEntry(propName);
            return this.createPropertyState(info, propEntry);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
    }

    private static NodeEntry createIntermediateNodeEntry(NodeEntry parentEntry, Name name, int index, ItemInfos infos) throws RepositoryException {
        Iterator childInfos;
        if (infos != null && (childInfos = infos.getChildInfos(parentEntry.getWorkspaceId())) != null) {
            parentEntry.setNodeEntries(childInfos);
        }
        NodeEntry entry = parentEntry.getOrAddNodeEntry(name, index, null);
        return entry;
    }

    private static void assertValidState(ItemState state, ItemInfo info) throws ItemNotFoundException, RepositoryException {
        if (state == null) {
            throw new ItemNotFoundException("HierarchyEntry does not belong to any existing ItemInfo. No ItemState was created.");
        }
        WorkspaceItemStateFactory.assertMatchingPath(info, state.getHierarchyEntry());
    }

    private static void assertMatchingPath(ItemInfo info, HierarchyEntry entry) throws ItemNotFoundException, RepositoryException {
        Path infoPath = info.getPath();
        if (!infoPath.equals(entry.getWorkspacePath())) {
            throw new ItemNotFoundException("HierarchyEntry does not belong the given ItemInfo.");
        }
    }

    private static boolean startsWithIllegalElement(Path.Element[] missingElems) {
        if (missingElems.length > 0) {
            return missingElems[0].denotesRoot();
        }
        return false;
    }

    private static NodeEntry getAncestor(HierarchyEntry entry, int degree) {
        NodeEntry parent;
        --degree;
        for (parent = entry.getParent(); parent != null && degree > 0; parent = parent.getParent(), --degree) {
        }
        if (degree != 0) {
            throw new IllegalArgumentException();
        }
        return parent;
    }

    private class ItemInfos
    implements Iterator {
        private final List prefetchQueue = new ArrayList();
        private final Map nodeInfos = new HashMap();
        private final Iterator infos;

        private ItemInfos(Iterator infos) {
            this.infos = infos;
        }

        public boolean hasNext() {
            if (!this.prefetchQueue.isEmpty()) {
                return true;
            }
            return this.prefetch();
        }

        public Object next() {
            if (this.prefetchQueue.isEmpty()) {
                throw new NoSuchElementException();
            }
            Object next = this.prefetchQueue.remove(0);
            if (next instanceof NodeInfo) {
                this.nodeInfos.remove(((NodeInfo)next).getId());
            }
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Iterator getChildInfos(NodeId parentId) {
            NodeInfo nodeInfo = (NodeInfo)this.nodeInfos.get(parentId);
            while (nodeInfo == null && this.prefetch()) {
                nodeInfo = (NodeInfo)this.nodeInfos.get(parentId);
            }
            return nodeInfo == null ? null : nodeInfo.getChildInfos();
        }

        private boolean prefetch() {
            if (this.infos.hasNext()) {
                ItemInfo info = (ItemInfo)this.infos.next();
                this.prefetchQueue.add(info);
                if (info.denotesNode()) {
                    NodeInfo nodeInfo = (NodeInfo)info;
                    this.nodeInfos.put(nodeInfo.getId(), nodeInfo);
                }
                return true;
            }
            return false;
        }
    }
}

