/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.util;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    private static Logger log = LoggerFactory.getLogger((Class)LogUtil.class);

    public static String safeGetJCRPath(Path qPath, PathResolver pathResolver) {
        try {
            return pathResolver.getJCRPath(qPath);
        }
        catch (NamespaceException e) {
            log.error("failed to convert " + qPath + " to JCR path.");
            return qPath.toString();
        }
    }

    public static String safeGetJCRPath(ItemState itemState, PathResolver pathResolver) {
        try {
            return LogUtil.safeGetJCRPath(itemState.getHierarchyEntry().getPath(), pathResolver);
        }
        catch (RepositoryException e) {
            log.error("failed to convert " + itemState.toString() + " to JCR path.");
            return itemState.toString();
        }
    }

    public static String saveGetJCRName(Name qName, NameResolver nameResolver) {
        try {
            return nameResolver.getJCRName(qName);
        }
        catch (NamespaceException e) {
            log.error("failed to convert " + qName + " to JCR name.");
            return qName.toString();
        }
    }

    public static String saveGetIdString(ItemId itemId, PathResolver pathResolver) {
        String jcrPath;
        Path p = itemId.getPath();
        if (p == null || pathResolver == null) {
            return itemId.toString();
        }
        StringBuffer bf = new StringBuffer();
        String uniqueID = itemId.getUniqueID();
        if (uniqueID != null) {
            bf.append(uniqueID).append(" - ");
        }
        try {
            jcrPath = pathResolver.getJCRPath(p);
        }
        catch (NamespaceException e) {
            jcrPath = p.toString();
        }
        bf.append(jcrPath);
        return bf.toString();
    }
}

