/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.util;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

public class StateUtility {
    public static Name[] getMixinNames(PropertyState ps) {
        if (!NameConstants.JCR_MIXINTYPES.equals(ps.getName())) {
            throw new IllegalArgumentException();
        }
        if (ps.getStatus() == 8) {
            return Name.EMPTY_ARRAY;
        }
        QValue[] values = ps.getValues();
        Name[] newMixins = new Name[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                newMixins[i] = values[i].getName();
                continue;
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return newMixins;
    }

    public static boolean isUuidOrMixin(Name propName) {
        return NameConstants.JCR_UUID.equals(propName) || NameConstants.JCR_MIXINTYPES.equals(propName);
    }

    public static boolean isMovedState(NodeState state) {
        if (state.isRoot()) {
            return false;
        }
        NodeEntry ne = state.getNodeEntry();
        return ne.isTransientlyMoved();
    }
}

