/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.version;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.jcr2spi.ItemLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.LazyItemIterator;
import org.apache.jackrabbit.jcr2spi.NodeImpl;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionHistoryImpl
extends NodeImpl
implements VersionHistory {
    private static Logger log = LoggerFactory.getLogger((Class)VersionHistoryImpl.class);
    private final NodeEntry vhEntry;
    private final NodeEntry labelNodeEntry;

    public VersionHistoryImpl(SessionImpl session, NodeState state, ItemLifeCycleListener[] listeners) throws VersionException, RepositoryException {
        super(session, state, listeners);
        this.vhEntry = (NodeEntry)state.getHierarchyEntry();
        this.labelNodeEntry = this.vhEntry.getNodeEntry(NameConstants.JCR_VERSIONLABELS, 1, true);
        if (this.labelNodeEntry == null) {
            String msg = "Unexpected error: nt:versionHistory requires a mandatory, autocreated child node jcr:versionLabels.";
            log.error(msg);
            throw new VersionException(msg);
        }
    }

    public String getVersionableUUID() throws RepositoryException {
        this.checkStatus();
        return this.getProperty(NameConstants.JCR_VERSIONABLEUUID).getString();
    }

    public Version getRootVersion() throws RepositoryException {
        this.checkStatus();
        NodeEntry vEntry = this.vhEntry.getNodeEntry(NameConstants.JCR_ROOTVERSION, 1, true);
        if (vEntry == null) {
            String msg = "Unexpected error: VersionHistory state does not contain a root version child node entry.";
            log.error(msg);
            throw new RepositoryException(msg);
        }
        return (Version)this.getItemManager().getItem(vEntry);
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        this.checkStatus();
        VersionHistoryImpl.refreshEntry(this.vhEntry);
        Iterator childIter = this.vhEntry.getNodeEntries();
        ArrayList<NodeEntry> versionEntries = new ArrayList<NodeEntry>();
        while (childIter.hasNext()) {
            NodeEntry entry = (NodeEntry)childIter.next();
            if (NameConstants.JCR_VERSIONLABELS.equals(entry.getName())) continue;
            versionEntries.add(entry);
        }
        return new LazyItemIterator(this.getItemManager(), (Iterator)new RangeIteratorAdapter(versionEntries));
    }

    public Version getVersion(String versionName) throws VersionException, RepositoryException {
        this.checkStatus();
        NodeState vState = this.getVersionState(versionName);
        return (Version)this.getItemManager().getItem(vState.getHierarchyEntry());
    }

    public Version getVersionByLabel(String label) throws RepositoryException {
        this.checkStatus();
        return this.getVersionByLabel(this.getQLabel(label));
    }

    public void addVersionLabel(String versionName, String label, boolean moveLabel) throws VersionException, RepositoryException {
        this.checkStatus();
        Name qLabel = this.getQLabel(label);
        NodeState vState = this.getVersionState(versionName);
        this.session.getVersionManager().addVersionLabel((NodeState)this.getItemState(), vState, qLabel, moveLabel);
    }

    public void removeVersionLabel(String label) throws VersionException, RepositoryException {
        this.checkStatus();
        Name qLabel = this.getQLabel(label);
        Version version = this.getVersionByLabel(qLabel);
        NodeState vState = this.getVersionState(version.getName());
        this.session.getVersionManager().removeVersionLabel((NodeState)this.getItemState(), vState, qLabel);
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        this.checkStatus();
        Name l = this.getQLabel(label);
        Name[] qLabels = this.getQLabels();
        for (int i = 0; i < qLabels.length; ++i) {
            if (!qLabels[i].equals(l)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVersionLabel(Version version, String label) throws VersionException, RepositoryException {
        this.checkValidVersion(version);
        String vUUID = version.getUUID();
        Name l = this.getQLabel(label);
        Name[] qLabels = this.getQLabels();
        for (int i = 0; i < qLabels.length; ++i) {
            if (!qLabels[i].equals(l)) continue;
            String uuid = this.getVersionByLabel(qLabels[i]).getUUID();
            return vUUID.equals(uuid);
        }
        return false;
    }

    public String[] getVersionLabels() throws RepositoryException {
        this.checkStatus();
        Name[] qLabels = this.getQLabels();
        String[] labels = new String[qLabels.length];
        for (int i = 0; i < qLabels.length; ++i) {
            labels[i] = this.session.getNameResolver().getJCRName(qLabels[i]);
        }
        return labels;
    }

    public String[] getVersionLabels(Version version) throws VersionException, RepositoryException {
        this.checkValidVersion(version);
        String vUUID = version.getUUID();
        ArrayList<String> vlabels = new ArrayList<String>();
        Name[] qLabels = this.getQLabels();
        for (int i = 0; i < qLabels.length; ++i) {
            String uuid = this.getVersionByLabel(qLabels[i]).getUUID();
            if (!vUUID.equals(uuid)) continue;
            vlabels.add(this.session.getNameResolver().getJCRName(qLabels[i]));
        }
        return vlabels.toArray(new String[vlabels.size()]);
    }

    public void removeVersion(String versionName) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        this.checkStatus();
        NodeState vState = this.getVersionState(versionName);
        this.session.getVersionManager().removeVersion((NodeState)this.getItemState(), vState);
    }

    public boolean isSame(Item otherItem) throws RepositoryException {
        this.checkStatus();
        if (otherItem instanceof VersionHistoryImpl) {
            VersionHistoryImpl other = (VersionHistoryImpl)otherItem;
            return this.vhEntry.getUniqueID().equals(other.vhEntry.getUniqueID());
        }
        return false;
    }

    protected void checkIsWritable() throws UnsupportedRepositoryOperationException, ConstraintViolationException, RepositoryException {
        super.checkIsWritable();
        throw new ConstraintViolationException("VersionHistory is protected");
    }

    protected boolean isWritable() throws RepositoryException {
        super.isWritable();
        return false;
    }

    private Name[] getQLabels() throws RepositoryException {
        VersionHistoryImpl.refreshEntry(this.labelNodeEntry);
        ArrayList<Name> labelNames = new ArrayList<Name>();
        Iterator it = this.labelNodeEntry.getPropertyEntries();
        while (it.hasNext()) {
            PropertyEntry pe = (PropertyEntry)it.next();
            if (NameConstants.JCR_PRIMARYTYPE.equals(pe.getName()) || NameConstants.JCR_MIXINTYPES.equals(pe.getName())) continue;
            labelNames.add(pe.getName());
        }
        return labelNames.toArray(new Name[labelNames.size()]);
    }

    private NodeState getVersionState(String versionName) throws VersionException, RepositoryException {
        try {
            Name vName = this.session.getNameResolver().getQName(versionName);
            VersionHistoryImpl.refreshEntry(this.vhEntry);
            NodeEntry vEntry = this.vhEntry.getNodeEntry(vName, 1, true);
            if (vEntry == null) {
                throw new VersionException("Version '" + versionName + "' does not exist in this version history.");
            }
            return vEntry.getNodeState();
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private Version getVersionByLabel(Name qLabel) throws VersionException, RepositoryException {
        VersionHistoryImpl.refreshEntry(this.labelNodeEntry);
        PropertyEntry pEntry = this.labelNodeEntry.getPropertyEntry(qLabel, true);
        if (pEntry == null) {
            throw new VersionException("Version with label '" + qLabel + "' does not exist.");
        }
        Node version = ((Property)this.getItemManager().getItem(pEntry)).getNode();
        return (Version)version;
    }

    private Name getQLabel(String label) throws RepositoryException {
        try {
            return this.session.getNameResolver().getQName(label);
        }
        catch (NameException e) {
            String error = "Invalid version label: " + e.getMessage();
            log.error(error);
            throw new RepositoryException(error, (Throwable)e);
        }
    }

    private void checkValidVersion(Version version) throws VersionException, RepositoryException {
        if (!version.getContainingHistory().isSame((Item)this)) {
            throw new VersionException("Specified version '" + version.getName() + "' is not part of this history.");
        }
    }

    private static void refreshEntry(NodeEntry entry) throws RepositoryException {
        entry.getNodeState();
    }
}

