/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.xml;

import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.xml.DocViewImportHandler;
import org.apache.jackrabbit.jcr2spi.xml.Importer;
import org.apache.jackrabbit.jcr2spi.xml.SysViewImportHandler;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ImportHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger((Class)ImportHandler.class);
    private final Importer importer;
    private final NamespaceRegistry nsReg;
    private final NamespaceResolver nsResolver;
    private final NameFactory nameFactory;
    private ContentHandler targetHandler;
    private boolean systemViewXML;
    private boolean initialized;
    private final NamespaceContext nsContext;
    private final NamePathResolver resolver;
    protected boolean nsContextStarted;

    public ImportHandler(Importer importer, NamespaceResolver nsResolver, NamespaceRegistry nsReg, NameFactory nameFactory, PathFactory pathFactory) {
        this.importer = importer;
        this.nsResolver = nsResolver;
        this.nsReg = nsReg;
        this.nameFactory = nameFactory;
        this.nsContext = new NamespaceContext();
        ParsingNameResolver nr = new ParsingNameResolver(nameFactory, (NamespaceResolver)this.nsContext);
        this.resolver = new DefaultNamePathResolver((NameResolver)nr, (PathResolver)new ParsingPathResolver(pathFactory, (NameResolver)nr));
    }

    public void warning(SAXParseException e) throws SAXException {
        log.warn("warning encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream", (Throwable)e);
    }

    public void error(SAXParseException e) throws SAXException {
        log.error("error encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream: " + e.toString());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        log.error("fatal error encountered at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + " while parsing XML stream: " + e.toString());
        throw e;
    }

    public void startDocument() throws SAXException {
        this.systemViewXML = false;
        this.initialized = false;
        this.targetHandler = null;
        this.nsContext.reset();
        this.nsContext.pushContext();
        try {
            String[] uris = this.nsReg.getURIs();
            for (int i = 0; i < uris.length; ++i) {
                this.nsContext.declarePrefix(this.nsResolver.getPrefix(uris[i]), uris[i]);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
        this.nsContextStarted = false;
    }

    public void endDocument() throws SAXException {
        this.targetHandler.endDocument();
        this.nsContext.reset();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.nsContextStarted) {
            this.nsContext.pushContext();
            this.nsContextStarted = true;
        }
        try {
            this.nsContext.getPrefix(uri);
        }
        catch (NamespaceException nse) {
            try {
                String newPrefix = "".equals(prefix) ? this.getUniquePrefix(uri) : prefix;
                this.nsReg.registerNamespace(newPrefix, uri);
            }
            catch (RepositoryException re) {
                throw new SAXException((Exception)((Object)re));
            }
        }
        this.nsContext.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.nsContextStarted) {
            this.nsContext.pushContext();
        } else {
            this.nsContextStarted = false;
        }
        if (!this.initialized) {
            this.systemViewXML = "http://www.jcp.org/jcr/sv/1.0".equals(namespaceURI);
            this.targetHandler = this.systemViewXML ? new SysViewImportHandler(this.importer, this.resolver) : new DocViewImportHandler(this.importer, this.resolver, this.nameFactory);
            this.targetHandler.startDocument();
            this.initialized = true;
        }
        this.targetHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.targetHandler.characters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.nsContext.popContext();
        this.targetHandler.endElement(namespaceURI, localName, qName);
    }

    public String getUniquePrefix(String uriHint) throws RepositoryException {
        return "_pre" + (this.nsReg.getPrefixes().length + 1);
    }

    class NamespaceContext
    implements NamespaceResolver {
        private final NamespaceSupport nsContext = new NamespaceSupport();
        private static final String DUMMY_DEFAULT_URI = " ";

        NamespaceContext() {
        }

        void popContext() {
            this.nsContext.popContext();
        }

        void pushContext() {
            this.nsContext.pushContext();
        }

        void reset() {
            this.nsContext.reset();
        }

        boolean declarePrefix(String prefix, String uri) {
            if ("".equals(uri)) {
                uri = DUMMY_DEFAULT_URI;
            }
            return this.nsContext.declarePrefix(prefix, uri);
        }

        public String getURI(String prefix) throws NamespaceException {
            String uri = this.nsContext.getURI(prefix);
            if (uri == null) {
                throw new NamespaceException("unknown prefix");
            }
            if (DUMMY_DEFAULT_URI.equals(uri)) {
                return "";
            }
            return uri;
        }

        public String getPrefix(String uri) throws NamespaceException {
            String prefix;
            if ("".equals(uri)) {
                uri = DUMMY_DEFAULT_URI;
            }
            if ((prefix = this.nsContext.getPrefix(uri)) == null) {
                if (uri.equals(this.nsContext.getURI(""))) {
                    return "";
                }
                throw new NamespaceException("unknown uri");
            }
            return prefix;
        }
    }
}

