/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvCmQueueTransport;
import com.tibco.tibrv.TibrvCmReviewCallback;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplCmTPortC;
import com.tibco.tibrv.TibrvImplMsgBuffer;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvRvdTransport;
import com.tibco.tibrv.TibrvTransport;

public class TibrvCmTransport
extends TibrvTransport {
    public static final double DEFAULT_TIME_LIMIT = 0.0;
    protected TibrvTransport _tport = null;
    protected String _cmName = null;
    private String _relayAgent = null;
    private String _ledgerName = null;
    private boolean _syncLedger = false;
    private boolean _requestOld = false;
    private double _defaultTimeLimit = 0.0;
    private static final String ERR_CMD = "Not permitted for Distributed CM transport";

    public TibrvCmTransport(TibrvRvdTransport tibrvRvdTransport) throws TibrvException {
        this._create(tibrvRvdTransport, null, false, null, false, null);
    }

    public TibrvCmTransport(TibrvRvdTransport tibrvRvdTransport, String string, boolean bl) throws TibrvException {
        this._create(tibrvRvdTransport, string, bl, null, false, null);
    }

    public TibrvCmTransport(TibrvRvdTransport tibrvRvdTransport, String string, boolean bl, String string2, boolean bl2) throws TibrvException {
        this._create(tibrvRvdTransport, string, bl, string2, bl2, null);
    }

    public TibrvCmTransport(TibrvRvdTransport tibrvRvdTransport, String string, boolean bl, String string2, boolean bl2, String string3) throws TibrvException {
        this._create(tibrvRvdTransport, string, bl, string2, bl2, string3);
    }

    private void _create(TibrvRvdTransport tibrvRvdTransport, String string, boolean bl, String string2, boolean bl2, String string3) throws TibrvException {
        if (tibrvRvdTransport == null) {
            throw new IllegalArgumentException("transport is null");
        }
        TibrvImpl tibrvImpl = Tibrv._impl;
        Tibrv.checkValid();
        tibrvRvdTransport.checkValid();
        if (tibrvImpl == null) {
            throw new TibrvException(4);
        }
        if (!Tibrv.isNativeImpl()) {
            throw new TibrvException("Must use native implementation", 27);
        }
        this._impl = new TibrvImplCmTPortC();
        Object[] objectArray = new Object[]{tibrvRvdTransport, string, new Boolean(bl), string2, new Boolean(bl2), string3};
        ((TibrvImplCmTPortC)this._impl).createCM(this, objectArray);
        this._tport = tibrvRvdTransport;
        this._cmName = string;
        this._relayAgent = string3;
        this._ledgerName = string2;
        this._syncLedger = bl2;
        this._requestOld = bl;
        this._valid = true;
        tibrvImpl.register(this);
    }

    public boolean isValid() {
        return this._valid;
    }

    public void destroy() {
        this.destroyImpl();
    }

    public void send(TibrvMsg tibrvMsg) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        super.send(tibrvMsg);
    }

    public TibrvMsg sendRequest(TibrvMsg tibrvMsg, double d) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        return super.sendRequest(tibrvMsg, d);
    }

    public void sendReply(TibrvMsg tibrvMsg, TibrvMsg tibrvMsg2) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        super.sendReply(tibrvMsg, tibrvMsg2);
    }

    public String createInbox() throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        return super.createInbox();
    }

    public TibrvRvdTransport getTransport() {
        return (TibrvRvdTransport)this._tport;
    }

    public String getName() {
        return this._cmName;
    }

    public String getRelayAgent() {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        return this._relayAgent;
    }

    public String getLedgerName() {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        return this._ledgerName;
    }

    public boolean getSyncLedger() {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        return this._syncLedger;
    }

    public boolean getRequestOld() {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        return this._requestOld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowListener(String string) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (string == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            TibrvImplCmTPortC tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
            tibrvImplCmTPortC.allowListener(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disallowListener(String string) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (string == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            TibrvImplCmTPortC tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
            tibrvImplCmTPortC.disallowListener(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String string, String string2) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            TibrvImplCmTPortC tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
            tibrvImplCmTPortC.addListener(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String string, String string2) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            TibrvImplCmTPortC tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
            tibrvImplCmTPortC.removeListener(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSendState(String string) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (string == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            TibrvImplCmTPortC tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
            tibrvImplCmTPortC.removeSendState(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireMessages(String string, long l) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (string == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            TibrvImplCmTPortC tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
            tibrvImplCmTPortC.expireMessages(string, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncLedger() throws TibrvException {
        TibrvImplCmTPortC tibrvImplCmTPortC;
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
        }
        tibrvImplCmTPortC.syncLedger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToRelayAgent() throws TibrvException {
        TibrvImplCmTPortC tibrvImplCmTPortC;
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (this._relayAgent == null) {
            throw new TibrvException("Relay Agent not specified", 27);
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
        }
        tibrvImplCmTPortC.connectToRelayAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectFromRelayAgent() throws TibrvException {
        TibrvImplCmTPortC tibrvImplCmTPortC;
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (this._relayAgent == null) {
            throw new TibrvException("Relay Agent not specified", 27);
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
        }
        tibrvImplCmTPortC.disconnectFromRelayAgent();
    }

    public double getDefaultTimeLimit() {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        return this._defaultTimeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTimeLimit(double d) throws TibrvException {
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("negative time value");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            TibrvImplCmTPortC tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
            tibrvImplCmTPortC.setDefaultTimeLimit(d);
            this._defaultTimeLimit = d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviewLedger(TibrvCmReviewCallback tibrvCmReviewCallback, String string, Object object) throws TibrvException {
        TibrvImplCmTPortC tibrvImplCmTPortC;
        if (this instanceof TibrvCmQueueTransport) {
            throw new IllegalStateException(ERR_CMD);
        }
        if (tibrvCmReviewCallback == null || string == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object2 = this._lock;
        synchronized (object2) {
            this.checkValid();
            tibrvImplCmTPortC = (TibrvImplCmTPortC)this._impl;
        }
        tibrvImplCmTPortC.reviewLedger(tibrvCmReviewCallback, string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPublisherInactivityDiscardInterval(int n) throws TibrvException {
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            ((TibrvImplCmTPortC)this._impl).setPublisherInactivityDiscardInterval(n);
        }
    }

    private boolean invokeReview(Object object, byte[] byArray, TibrvMsg tibrvMsg, Object object2) {
        TibrvCmReviewCallback tibrvCmReviewCallback = (TibrvCmReviewCallback)object;
        String string = "";
        try {
            string = TibrvImplMsgBuffer.stringFromBytes(byArray, 0, byArray.length, TibrvMsg.getStringEncoding());
        }
        catch (TibrvException tibrvException) {
            string = new String(byArray);
        }
        if (tibrvCmReviewCallback != null) {
            return tibrvCmReviewCallback.onLedgerMsg(this, string, tibrvMsg, object2);
        }
        return true;
    }

    protected TibrvTransport getDependTport() {
        return this._tport;
    }

    TibrvCmTransport() throws TibrvException {
        Tibrv.checkValid();
    }

    protected void checkValid() throws TibrvException {
        super.checkValid();
        TibrvTransport tibrvTransport = this._tport;
        if (tibrvTransport == null) {
            throw new TibrvException(2);
        }
        tibrvTransport.checkValid();
    }
}

