/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import java.util.Date;

public class TibrvDate
extends Date {
    public static final long MAX_SECONDS = 0x7FFFFFFFFFL;
    public static final long MIN_SECONDS = -549755813888L;
    private long _seconds = 0L;
    private int _nanoseconds = 0;
    private static final long THOUSAND = 1000L;
    private static final long MILLION = 1000000L;
    private static final long BILLION = 1000000000L;

    public TibrvDate() {
        this.setMilliseconds(this.getTime());
    }

    public TibrvDate(long l) {
        super(l);
        this.setMilliseconds(l);
    }

    public TibrvDate(Date date) {
        super(date.getTime());
        this.setMilliseconds(date.getTime());
    }

    public TibrvDate(long l, int n) {
        this.setTime(l, n);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof TibrvDate && this.getTimeSeconds() == ((TibrvDate)object).getTimeSeconds() && this.getTimeNanoseconds() == ((TibrvDate)object).getTimeNanoseconds();
    }

    public void setTime(long l, int n) {
        if (l < -549755813888L || l > 0x7FFFFFFFFFL) {
            throw new IllegalArgumentException("Seconds out of range");
        }
        if (n < 0 || n > 999999999) {
            throw new IllegalArgumentException("Nanoseconds out of range");
        }
        long l2 = l * 1000L + (long)(n / 1000000);
        super.setTime(l2);
        this._seconds = l;
        this._nanoseconds = n;
    }

    public void setTime(long l) {
        this.setMilliseconds(l);
        super.setTime(l);
    }

    public long getTimeSeconds() {
        return this._seconds;
    }

    public int getTimeNanoseconds() {
        return this._nanoseconds;
    }

    private final void setMilliseconds(long l) {
        long l2 = l / 1000L;
        long l3 = l % 1000L * 1000000L;
        if (l < 0L && l3 != 0L) {
            --l2;
            l3 = 1000000000L + l3;
        }
        if (l2 > 0x7FFFFFFFFFL || l2 < -549755813888L) {
            throw new IllegalArgumentException("Date out of range");
        }
        this._seconds = l2;
        this._nanoseconds = (int)l3;
    }
}

