/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvDispatchable;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvProcessTransport;
import com.tibco.tibrv.TibrvStatus;
import com.tibco.tibrv.TibrvTransport;

public class TibrvDispatcher
extends Thread {
    public static final String DEFAULT_NAME = "Tibrv Dispatcher";
    protected boolean _valid = false;
    protected Object _lock = new Object();
    private static ThreadGroup _group = null;
    private static final double NO_TIMEOUT = -1.0;
    private double _timeout = -1.0;
    private TibrvDispatchable _dispatchable = null;
    private boolean _running = false;
    private byte[] _jniptr = null;

    public TibrvDispatcher(TibrvDispatchable tibrvDispatchable) {
        super(DEFAULT_NAME);
        this.create(tibrvDispatchable, -1.0);
    }

    public TibrvDispatcher(TibrvDispatchable tibrvDispatchable, double d) {
        super(DEFAULT_NAME);
        if (d != -1.0 && d < 0.0) {
            throw new IllegalArgumentException("Invalid timeout value");
        }
        this.create(tibrvDispatchable, d);
    }

    public TibrvDispatcher(String string, TibrvDispatchable tibrvDispatchable) {
        super(string);
        this.create(tibrvDispatchable, -1.0);
    }

    public TibrvDispatcher(String string, TibrvDispatchable tibrvDispatchable, double d) {
        super(string);
        if (d != -1.0 && d < 0.0) {
            throw new IllegalArgumentException("Invalid timeout value");
        }
        this.create(tibrvDispatchable, d);
    }

    public TibrvDispatcher(ThreadGroup threadGroup, String string, TibrvDispatchable tibrvDispatchable) {
        super(threadGroup, string);
        this.create(tibrvDispatchable, -1.0);
    }

    public TibrvDispatcher(ThreadGroup threadGroup, String string, TibrvDispatchable tibrvDispatchable, double d) {
        super(threadGroup, string);
        if (d != -1.0 && d < 0.0) {
            throw new IllegalArgumentException("Invalid timeout value");
        }
        this.create(tibrvDispatchable, d);
    }

    private void create(TibrvDispatchable tibrvDispatchable, double d) {
        TibrvImpl tibrvImpl = Tibrv._impl;
        if (!Tibrv.isValid()) {
            throw new IllegalStateException("Tibrv is not open");
        }
        if (tibrvDispatchable == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this._dispatchable = tibrvDispatchable;
        this._timeout = d;
        try {
            tibrvImpl.register(this);
        }
        catch (TibrvException tibrvException) {
            throw new IllegalStateException("Tibrv is not open");
        }
        this._valid = true;
        this.start();
    }

    public final boolean isValid() {
        return this._valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TibrvDispatchable getDispatchable() {
        Object object = this._lock;
        synchronized (object) {
            return this._dispatchable;
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this._lock;
        synchronized (object) {
            if (!this._valid) {
                return;
            }
            this._valid = false;
        }
        if (this != Thread.currentThread()) {
            this.interrupt();
        }
        object = Tibrv._impl;
        if (Tibrv.isNativeImpl()) {
            if (object == null) {
                return;
            }
            if (this != Thread.currentThread()) {
                if (this._running) {
                    try {
                        ((TibrvImpl)object).signalDispatcher(this);
                    }
                    catch (TibrvException tibrvException) {
                        // empty catch block
                    }
                }
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                ((TibrvImpl)object).destroyDispatcher(this);
            }
            catch (TibrvException tibrvException) {}
        } else if (this != Thread.currentThread()) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ((TibrvImpl)object).unregister(this);
    }

    private void sendAdv(int n) {
        try {
            TibrvMsg tibrvMsg = null;
            tibrvMsg = TibrvTransport.buildAdvisory("INFO", "SYSTEM", "DISPATCHER.THREAD_EXITED." + this.getName(), null);
            if (tibrvMsg != null) {
                tibrvMsg.add("status", n);
                tibrvMsg.add("description", TibrvStatus.getText(n));
                TibrvProcessTransport tibrvProcessTransport = Tibrv.processTransport();
                if (tibrvProcessTransport != null) {
                    tibrvProcessTransport.send(tibrvMsg);
                }
            }
        }
        catch (TibrvException tibrvException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void checkValid() throws TibrvException {
        if (!this._valid) {
            throw new TibrvException(53);
        }
    }
}

