/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import java.net.InetAddress;
import java.util.StringTokenizer;

public class TibrvIPAddr {
    private int _addr = 0;

    public TibrvIPAddr(int n) {
        this._addr = n;
    }

    public TibrvIPAddr(byte by, byte by2, byte by3, byte by4) {
        byte[] byArray = new byte[]{by, by2, by3, by4};
        this.setAddr(byArray);
    }

    public TibrvIPAddr(byte[] byArray) {
        this.setAddr(byArray);
    }

    public TibrvIPAddr(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.setAddr(inetAddress.getAddress());
    }

    public TibrvIPAddr(String string) throws NumberFormatException {
        this.setAddr(string);
    }

    public TibrvIPAddr(TibrvIPAddr tibrvIPAddr) {
        if (tibrvIPAddr == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.setAddr(tibrvIPAddr.getAddr());
    }

    public boolean equals(Object object) {
        return object != null && object instanceof TibrvIPAddr && this.getAddr() == ((TibrvIPAddr)object).getAddr();
    }

    public final int getAddr() {
        return this._addr;
    }

    public final String getAsString() {
        return String.valueOf(this._addr >>> 24 & 0xFF) + "." + String.valueOf(this._addr >>> 16 & 0xFF) + "." + String.valueOf(this._addr >>> 8 & 0xFF) + "." + String.valueOf(this._addr & 0xFF);
    }

    public final byte[] getAsBytes() {
        byte[] byArray = new byte[]{(byte)(this._addr >>> 24 & 0xFF), (byte)(this._addr >>> 16 & 0xFF), (byte)(this._addr >>> 8 & 0xFF), (byte)(this._addr & 0xFF)};
        return byArray;
    }

    private final void setAddr(int n) {
        this._addr = n;
    }

    private final void setAddr(byte[] byArray) {
        if (byArray == null || byArray.length != 4) {
            throw new IllegalArgumentException("Parameter must be array of 4 bytes");
        }
        this._addr = (byArray[0] << 24 & 0xFF000000) + (byArray[1] << 16 & 0xFF0000) + (byArray[2] << 8 & 0xFF00) + (byArray[3] & 0xFF);
    }

    private final void setAddr(String string) throws NumberFormatException {
        if (string == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        int n = 0;
        int n2 = 3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = Integer.parseInt(string2);
            if (n3 < 0 || n3 > 255) {
                throw new NumberFormatException("Invalid IP address string");
            }
            n |= n3 << n2 * 8;
            if (--n2 >= 0) continue;
        }
        if (n2 != -1) {
            throw new NumberFormatException("Invalid IP address string");
        }
        this._addr = n;
    }

    public String toString() {
        return this.getAsString();
    }
}

