/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

public class TibrvIPPort {
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    private int _port = 0;

    public TibrvIPPort(int n) {
        this.setPort(n);
    }

    public TibrvIPPort(TibrvIPPort tibrvIPPort) {
        if (tibrvIPPort == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        this.setPort(tibrvIPPort.getPort());
    }

    public TibrvIPPort(byte by, byte by2) {
        int n = (by << 8 | by2 & 0xFF) & 0xFFFF;
        this.setPort(n);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof TibrvIPPort && this.getPort() == ((TibrvIPPort)object).getPort();
    }

    public int getPort() {
        return this._port;
    }

    public final byte[] getAsBytes() {
        byte[] byArray = new byte[]{(byte)(this._port >>> 8 & 0xFF), (byte)(this._port & 0xFF)};
        return byArray;
    }

    private final void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port out of range: " + n);
        }
        this._port = n;
    }

    public String toString() {
        return String.valueOf(this._port);
    }
}

