/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvDispatcher;
import com.tibco.tibrv.TibrvEvent;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplRepl;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvQueueGroup;
import com.tibco.tibrv.TibrvTimer;
import com.tibco.tibrv.TibrvTransport;
import java.util.Vector;

abstract class TibrvImpl {
    Vector _transports = null;
    Vector _events = null;
    Vector _queues = null;
    Vector _queueGroups = null;
    Vector _dispatchers = null;

    TibrvImpl() {
    }

    public abstract String getCmVersion() throws TibrvException;

    public abstract String getFtVersion() throws TibrvException;

    public abstract void open(int var1, int var2, int var3) throws TibrvException;

    public abstract void close() throws TibrvException;

    public abstract void createTimer(TibrvTimer var1) throws TibrvException;

    public abstract void readdTimer(TibrvTimer var1);

    public abstract void destroyTimer(TibrvTimer var1);

    public abstract void resetInterval(TibrvTimer var1, double var2) throws TibrvException;

    public void createDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
    }

    public void signalDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
    }

    public void destroyDispatcher(TibrvDispatcher tibrvDispatcher) throws TibrvException {
    }

    private boolean notInitError(int n) {
        return n == 2 || n == 63 || n == 62 || n == 60 || n == 907 || n == 4;
    }

    public synchronized void destroyAll() throws TibrvException {
        this.destroyDispatchers();
        this.destroyTransports();
        this.destroyQueues();
        this.destroyQueueGroups();
        this.destroyEvents();
        this.destroyRegistry();
    }

    public synchronized void destroyTransports() throws TibrvException {
        if (this._transports == null) {
            return;
        }
        while (this._transports.size() > 0) {
            TibrvTransport tibrvTransport = (TibrvTransport)this._transports.firstElement();
            this._transports.removeElementAt(0);
            if (!tibrvTransport.isValid()) continue;
            tibrvTransport.destroyImpl();
        }
    }

    public synchronized void destroyQueues() throws TibrvException {
        if (this._queues == null) {
            return;
        }
        while (this._queues.size() > 0) {
            TibrvQueue tibrvQueue = (TibrvQueue)this._queues.firstElement();
            this._queues.removeElementAt(0);
            if (!tibrvQueue.isValid()) continue;
            tibrvQueue.destroyImpl();
        }
    }

    public synchronized void destroyQueueGroups() throws TibrvException {
        if (this._queueGroups == null) {
            return;
        }
        while (this._queueGroups.size() > 0) {
            TibrvQueueGroup tibrvQueueGroup = (TibrvQueueGroup)this._queueGroups.firstElement();
            this._queueGroups.removeElementAt(0);
            if (!tibrvQueueGroup.isValid()) continue;
            tibrvQueueGroup.destroy();
        }
    }

    public synchronized void destroyDispatchers() throws TibrvException {
        if (this._dispatchers == null) {
            return;
        }
        while (this._dispatchers.size() > 0) {
            TibrvDispatcher tibrvDispatcher = (TibrvDispatcher)this._dispatchers.firstElement();
            this._dispatchers.removeElementAt(0);
            tibrvDispatcher.destroy();
        }
    }

    public synchronized void destroyEvents() throws TibrvException {
        if (this._events == null) {
            return;
        }
        while (this._events.size() > 0) {
            TibrvEvent tibrvEvent = (TibrvEvent)this._events.firstElement();
            this._events.removeElementAt(0);
            this.destroyEvent(tibrvEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyQueueEvents(TibrvQueue tibrvQueue) throws TibrvException {
        TibrvEvent tibrvEvent;
        Vector<TibrvEvent> vector = null;
        TibrvImpl tibrvImpl = this;
        synchronized (tibrvImpl) {
            if (this._events == null) {
                return;
            }
            vector = new Vector<TibrvEvent>();
            for (int i = 0; i < this._events.size(); ++i) {
                tibrvEvent = (TibrvEvent)this._events.elementAt(i);
                if (tibrvEvent.getQueue() != tibrvQueue) continue;
                vector.addElement(tibrvEvent);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            tibrvEvent = (TibrvEvent)vector.elementAt(i);
            this.destroyEvent(tibrvEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyTransportDependents(TibrvTransport tibrvTransport) {
        TibrvTransport tibrvTransport2;
        TibrvEvent tibrvEvent;
        Vector<TibrvEvent> vector = null;
        Vector<TibrvTransport> vector2 = null;
        TibrvImpl tibrvImpl = this;
        synchronized (tibrvImpl) {
            int n;
            if (this._events != null) {
                vector = new Vector<TibrvEvent>();
                for (n = 0; n < this._events.size(); ++n) {
                    tibrvEvent = (TibrvEvent)this._events.elementAt(n);
                    tibrvTransport2 = tibrvEvent.getDependTport();
                    if (tibrvTransport2 == null || tibrvTransport2 != tibrvTransport) continue;
                    vector.addElement(tibrvEvent);
                }
            }
            if (this._transports != null) {
                vector2 = new Vector<TibrvTransport>();
                for (n = 0; n < this._transports.size(); ++n) {
                    tibrvTransport2 = (TibrvTransport)this._transports.elementAt(n);
                    TibrvTransport tibrvTransport3 = tibrvTransport2.getDependTport();
                    if (tibrvTransport3 == null || tibrvTransport3 != tibrvTransport) continue;
                    vector2.addElement(tibrvTransport2);
                }
            }
        }
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                tibrvTransport2 = (TibrvTransport)vector2.elementAt(i);
                this.destroyTport(tibrvTransport2);
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                tibrvEvent = (TibrvEvent)vector.elementAt(i);
                this.destroyEvent(tibrvEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyEvent(TibrvEvent tibrvEvent) {
        if (tibrvEvent.isValid()) {
            if (tibrvEvent instanceof TibrvImplRepl) {
                TibrvEvent tibrvEvent2 = tibrvEvent;
                synchronized (tibrvEvent2) {
                    tibrvEvent.notifyAll();
                }
            }
            tibrvEvent.destroy();
        }
    }

    private void destroyTport(TibrvTransport tibrvTransport) {
        if (tibrvTransport.isValid()) {
            tibrvTransport.destroy();
        }
    }

    public synchronized void register(Object object) throws TibrvException {
        if (this._transports == null) {
            throw new TibrvException("Tibrv is not open", 4);
        }
        if (object instanceof TibrvTransport) {
            this._transports.insertElementAt(object, 0);
        } else if (object instanceof TibrvEvent) {
            this._events.addElement(object);
        } else if (object instanceof TibrvQueue) {
            this._queues.addElement(object);
        } else if (object instanceof TibrvQueueGroup) {
            this._queueGroups.addElement(object);
        } else if (object instanceof TibrvDispatcher) {
            this._dispatchers.addElement(object);
        }
    }

    public synchronized void unregister(Object object) {
        if (this._transports == null) {
            return;
        }
        if (object instanceof TibrvTransport) {
            this._transports.removeElement(object);
        } else if (object instanceof TibrvEvent) {
            this._events.removeElement(object);
        } else if (object instanceof TibrvQueue) {
            this._queues.removeElement(object);
        } else if (object instanceof TibrvQueueGroup) {
            this._queueGroups.removeElement(object);
        } else if (object instanceof TibrvDispatcher) {
            this._dispatchers.removeElement(object);
        }
    }

    public synchronized void createRegistry() {
        this._transports = new Vector();
        this._events = new Vector();
        this._queues = new Vector();
        this._queueGroups = new Vector();
        this._dispatchers = new Vector();
    }

    public synchronized void destroyRegistry() {
        this._transports = null;
        this._events = null;
        this._queues = null;
        this._queueGroups = null;
        this._dispatchers = null;
    }
}

