/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvCmListener;
import com.tibco.tibrv.TibrvCmQueueTransport;
import com.tibco.tibrv.TibrvCmReviewCallback;
import com.tibco.tibrv.TibrvCmTransport;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplQueue;
import com.tibco.tibrv.TibrvImplQueueC;
import com.tibco.tibrv.TibrvImplTPort;
import com.tibco.tibrv.TibrvImplTPortC;
import com.tibco.tibrv.TibrvListener;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvMsgField;
import com.tibco.tibrv.TibrvRvdTransport;
import com.tibco.tibrv.TibrvTransport;

class TibrvImplCmTPortC
implements TibrvImplTPort {
    private int _handle = 0;
    private TibrvCmTransport _parent = null;
    protected int _type = 0;
    private static final int _TYPE_CM = 1;
    private static final int _TYPE_CMDIST = 2;

    protected TibrvImplCmTPortC() {
    }

    void createCMDist(TibrvTransport tibrvTransport, Object[] objectArray) throws TibrvException {
        this._parent = (TibrvCmQueueTransport)tibrvTransport;
        TibrvRvdTransport tibrvRvdTransport = (TibrvRvdTransport)objectArray[0];
        TibrvImplTPortC tibrvImplTPortC = (TibrvImplTPortC)tibrvRvdTransport._impl;
        if (tibrvImplTPortC == null) {
            throw new TibrvException(2);
        }
        this._handle = this.natCmdCreate(tibrvImplTPortC._handle, TibrvMsg.defStringToBytes((String)objectArray[1]), (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4], (Double)objectArray[5], (Double)objectArray[6]);
    }

    void createCM(TibrvTransport tibrvTransport, Object[] objectArray) throws TibrvException {
        this._type = 1;
        this._parent = (TibrvCmTransport)tibrvTransport;
        TibrvRvdTransport tibrvRvdTransport = (TibrvRvdTransport)objectArray[0];
        TibrvImplTPortC tibrvImplTPortC = (TibrvImplTPortC)tibrvRvdTransport._impl;
        if (tibrvImplTPortC == null) {
            throw new TibrvException(2);
        }
        this._handle = this.natCreate(tibrvImplTPortC._handle, TibrvMsg.defStringToBytes((String)objectArray[1]), (Boolean)objectArray[2], TibrvMsg.defStringToBytes((String)objectArray[3]), (Boolean)objectArray[4], TibrvMsg.defStringToBytes((String)objectArray[5]));
    }

    public void create(TibrvTransport tibrvTransport, Object[] objectArray) throws TibrvException {
        throw new TibrvException(27);
    }

    public void setDescription(String string) throws TibrvException {
    }

    public boolean isRva() {
        return false;
    }

    public void destroy() {
        int n = this._handle;
        this._handle = 0;
        try {
            this.natDestroy(n, this._type);
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    public void send(TibrvMsg tibrvMsg) throws TibrvException {
        byte[] byArray = tibrvMsg.getAsBytes();
        byte[] byArray2 = null;
        int n = 0;
        TibrvMsg tibrvMsg2 = tibrvMsg.getEnvelope();
        if (tibrvMsg2 != null) {
            byArray2 = tibrvMsg2.getAsBytes();
            n = byArray2.length;
        }
        byte[] byArray3 = this.natSend(this._handle, byArray, byArray.length, byArray2, n, tibrvMsg.getSendSubjectAsBytes(), tibrvMsg.getReplySubjectAsBytes());
        this._addEnvelopeFields(tibrvMsg, byArray3);
    }

    void _addEnvelopeFields(TibrvMsg tibrvMsg, byte[] byArray) throws TibrvException {
        if (byArray == null) {
            return;
        }
        TibrvMsg tibrvMsg2 = new TibrvMsg(byArray);
        TibrvMsg tibrvMsg3 = tibrvMsg.getCreateEnvelope();
        for (int i = 0; i < tibrvMsg2.getNumFields(); ++i) {
            TibrvMsgField tibrvMsgField = tibrvMsg2.getFieldByIndex(i);
            tibrvMsg3.removeField(tibrvMsgField.name, tibrvMsgField.id);
            tibrvMsg3._addField(tibrvMsgField.name, tibrvMsgField.id, tibrvMsgField.data, tibrvMsgField.type, tibrvMsgField.type);
        }
    }

    public TibrvMsg sendRequest(TibrvMsg tibrvMsg, double d) throws TibrvException {
        Object[] objectArray;
        byte[] byArray = tibrvMsg.getAsBytes();
        byte[] byArray2 = null;
        int n = 0;
        TibrvMsg tibrvMsg2 = tibrvMsg.getEnvelope();
        if (tibrvMsg2 != null) {
            byArray2 = tibrvMsg2.getAsBytes();
            n = byArray2.length;
        }
        if ((objectArray = this.natSendRequest(this._handle, byArray, byArray.length, byArray2, n, tibrvMsg.getSendSubjectAsBytes(), d)) == null) {
            return null;
        }
        if (objectArray[1] != null) {
            this._addEnvelopeFields(tibrvMsg, (byte[])objectArray[1]);
        }
        return (TibrvMsg)objectArray[0];
    }

    public void sendReply(TibrvMsg tibrvMsg, TibrvMsg tibrvMsg2) throws TibrvException {
        tibrvMsg.setSendSubject(tibrvMsg2.getReplySubject());
        this.send(tibrvMsg);
    }

    public String createInbox() throws TibrvException {
        TibrvRvdTransport tibrvRvdTransport = this._parent.getTransport();
        if (tibrvRvdTransport != null) {
            return tibrvRvdTransport.createInbox();
        }
        throw new TibrvException(2);
    }

    public void createListener(TibrvListener tibrvListener) throws TibrvException {
        try {
            TibrvImplQueue tibrvImplQueue = tibrvListener.getQueue()._impl;
            if (tibrvListener.getQueue().isValid()) {
                this.natCreateListener(this._handle, tibrvListener, ((TibrvImplQueueC)tibrvImplQueue)._handle, TibrvMsg.defStringToBytes(tibrvListener.getSubject()));
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new TibrvException(62);
    }

    public void destroyListener(TibrvListener tibrvListener, int n) {
        try {
            this.natDestroyListener(this._handle, tibrvListener, n);
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    public void allowListener(String string) throws TibrvException {
        this.natAllowListener(this._handle, TibrvMsg.defStringToBytes(string));
    }

    public void disallowListener(String string) throws TibrvException {
        this.natDisallowListener(this._handle, TibrvMsg.defStringToBytes(string));
    }

    public void addListener(String string, String string2) throws TibrvException {
        this.natAddListener(this._handle, TibrvMsg.defStringToBytes(string), TibrvMsg.defStringToBytes(string2));
    }

    public void removeListener(String string, String string2) throws TibrvException {
        this.natRemoveListener(this._handle, TibrvMsg.defStringToBytes(string), TibrvMsg.defStringToBytes(string2));
    }

    public void removeSendState(String string) throws TibrvException {
        this.natRemovePubState(this._handle, TibrvMsg.defStringToBytes(string));
    }

    public void expireMessages(String string, long l) throws TibrvException {
        this.natExpireMessages(this._handle, TibrvMsg.defStringToBytes(string), l);
    }

    public void syncLedger() throws TibrvException {
        this.natSyncLedger(this._handle);
    }

    public void connectToRelayAgent() throws TibrvException {
        this.natConnRelayAgent(this._handle);
    }

    public void disconnectFromRelayAgent() throws TibrvException {
        this.natDisconnRelayAgent(this._handle);
    }

    public void setDefaultTimeLimit(double d) throws TibrvException {
        this.natSetDefTimeLimit(this._handle, d);
    }

    public double getDefaultTimeLimit() throws TibrvException {
        return this.natGetDefTimeLimit(this._handle);
    }

    public void reviewLedger(TibrvCmReviewCallback tibrvCmReviewCallback, String string, Object object) throws TibrvException {
        this.natReviewLedger(this._handle, this._parent, tibrvCmReviewCallback, TibrvMsg.defStringToBytes(string), object);
    }

    public void setExplicitConfirm(TibrvCmListener tibrvCmListener) throws TibrvException {
        this.natSetExplConfirm(tibrvCmListener);
    }

    public void confirmMsg(TibrvCmListener tibrvCmListener, TibrvMsg tibrvMsg) throws TibrvException {
        TibrvMsg tibrvMsg2 = tibrvMsg.getEnvelope();
        if (tibrvMsg2 == null) {
            throw new TibrvException("Can not confirm non-CM message", 42);
        }
        byte[] byArray = tibrvMsg2.getAsBytes();
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        String string = tibrvMsg.getSendSubject();
        if (string != null) {
            byArray2 = TibrvMsg.defStringToBytes(string);
        }
        if ((string = tibrvMsg.getReplySubject()) != null) {
            byArray3 = TibrvMsg.defStringToBytes(string);
        }
        this.natConfirmMsg(tibrvCmListener, byArray, byArray.length, byArray2, byArray3);
    }

    public void setPublisherInactivityDiscardInterval(int n) throws TibrvException {
        this.natSetPublisherInactivityDiscardInterval(this._handle, n);
    }

    protected void cmdSetCompleteTime(double d) throws TibrvException {
        this.natCmdSetCompleteTime(this._handle, d);
    }

    protected void cmdSetWorkerWeight(int n) throws TibrvException {
        this.natCmdSetWorkerWeight(this._handle, n);
    }

    protected void cmdSetWorkerTasks(int n) throws TibrvException {
        this.natCmdSetWorkerTasks(this._handle, n);
    }

    protected void cmdSetTaskBacklogLimitInBytes(int n) throws TibrvException {
        this.natCmdSetTaskBacklogLimitInBytes(this._handle, n);
    }

    protected void cmdSetTaskBacklogLimitInMessages(int n) throws TibrvException {
        this.natCmdSetTaskBacklogLimitInMessages(this._handle, n);
    }

    protected void finalize() throws Throwable {
        if (this._handle != 0) {
            try {
                this.natDestroy(this._handle, this._type);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private native int natCreate(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6) throws TibrvException;

    private native void natDestroy(int var1, int var2) throws TibrvException;

    private native byte[] natSend(int var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, byte[] var7) throws TibrvException;

    private native Object[] natSendRequest(int var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, double var7) throws TibrvException;

    private native void natCreateListener(int var1, TibrvListener var2, int var3, byte[] var4) throws TibrvException;

    private native void natDestroyListener(int var1, TibrvListener var2, int var3) throws TibrvException;

    private native void natAllowListener(int var1, byte[] var2) throws TibrvException;

    private native void natDisallowListener(int var1, byte[] var2) throws TibrvException;

    private native void natAddListener(int var1, byte[] var2, byte[] var3) throws TibrvException;

    private native void natRemoveListener(int var1, byte[] var2, byte[] var3) throws TibrvException;

    private native void natRemovePubState(int var1, byte[] var2) throws TibrvException;

    private native void natExpireMessages(int var1, byte[] var2, long var3) throws TibrvException;

    private native void natSyncLedger(int var1) throws TibrvException;

    private native void natConnRelayAgent(int var1) throws TibrvException;

    private native void natDisconnRelayAgent(int var1) throws TibrvException;

    private native double natGetDefTimeLimit(int var1) throws TibrvException;

    private native void natSetDefTimeLimit(int var1, double var2) throws TibrvException;

    private native void natReviewLedger(int var1, TibrvCmTransport var2, TibrvCmReviewCallback var3, byte[] var4, Object var5) throws TibrvException;

    private native void natSetExplConfirm(TibrvCmListener var1) throws TibrvException;

    private native void natConfirmMsg(TibrvCmListener var1, byte[] var2, int var3, byte[] var4, byte[] var5) throws TibrvException;

    private native void natSetPublisherInactivityDiscardInterval(int var1, int var2) throws TibrvException;

    private native int natCmdCreate(int var1, byte[] var2, int var3, int var4, int var5, double var6, double var8) throws TibrvException;

    private native void natCmdSetCompleteTime(int var1, double var2) throws TibrvException;

    private native void natCmdSetWorkerWeight(int var1, int var2) throws TibrvException;

    private native void natCmdSetWorkerTasks(int var1, int var2) throws TibrvException;

    private native void natCmdSetTaskBacklogLimitInBytes(int var1, int var2) throws TibrvException;

    private native void natCmdSetTaskBacklogLimitInMessages(int var1, int var2) throws TibrvException;
}

