/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvDate;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvIPAddr;
import com.tibco.tibrv.TibrvIPPort;
import com.tibco.tibrv.TibrvImplConst;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvXml;
import java.net.InetAddress;
import java.util.Date;

class TibrvImplMsgUtil
implements TibrvImplConst {
    TibrvImplMsgUtil() {
    }

    public static final String getTypeName(short s) {
        Object var1_1 = null;
        switch (s) {
            case 0: {
                return "DEFAULT";
            }
            case 1: {
                return "MSG";
            }
            case 3: {
                return "DATETIME";
            }
            case 8: {
                return "STRING";
            }
            case 9: {
                return "BOOL";
            }
            case 14: {
                return "I8";
            }
            case 15: {
                return "U8";
            }
            case 16: {
                return "I16";
            }
            case 17: {
                return "U16";
            }
            case 18: {
                return "I32";
            }
            case 19: {
                return "U32";
            }
            case 20: {
                return "I64";
            }
            case 21: {
                return "U64";
            }
            case 24: {
                return "F32";
            }
            case 25: {
                return "F64";
            }
            case 26: {
                return "IPPORT16";
            }
            case 27: {
                return "IPADDR32";
            }
            case 32: {
                return "ENCRYPTED";
            }
            case 7: {
                return "OPAQUE";
            }
            case 34: {
                return "I8ARRAY";
            }
            case 35: {
                return "U8ARRAY";
            }
            case 36: {
                return "I16ARRAY";
            }
            case 37: {
                return "U16ARRAY";
            }
            case 38: {
                return "I32ARRAY";
            }
            case 39: {
                return "U32ARRAY";
            }
            case 40: {
                return "I64ARRAY";
            }
            case 41: {
                return "U64ARRAY";
            }
            case 44: {
                return "F32ARRAY";
            }
            case 45: {
                return "F64ARRAY";
            }
            case 47: {
                return "XML";
            }
        }
        if (TibrvMsg.isUserType(s)) {
            return "USER_FIRST+" + (s - 128);
        }
        return "INVALID";
    }

    static final boolean isValidType(short s) {
        switch (s) {
            case 0: 
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 47: {
                return true;
            }
        }
        return TibrvMsg.isUserType(s);
    }

    static final boolean canConvertType(short s, short s2) {
        if (s == s2 || s2 == 0) {
            return true;
        }
        switch (s) {
            case 1: {
                return s2 == 1;
            }
            case 3: {
                return s2 == 3;
            }
            case 8: {
                return s2 == 8;
            }
            case 47: {
                return s2 == 47;
            }
            case 26: {
                switch (s2) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 26: {
                        return true;
                    }
                }
                break;
            }
            case 27: {
                switch (s2) {
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 27: {
                        return true;
                    }
                }
                break;
            }
            case 9: {
                switch (s2) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 25: {
                        return true;
                    }
                }
                break;
            }
            case 14: 
            case 15: {
                switch (s2) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 25: {
                        return true;
                    }
                }
                break;
            }
            case 16: {
                switch (s2) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 25: 
                    case 26: {
                        return true;
                    }
                }
                break;
            }
            case 18: {
                switch (s2) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        return true;
                    }
                }
                break;
            }
            case 20: {
                switch (s2) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        return true;
                    }
                }
                break;
            }
            case 24: {
                switch (s2) {
                    case 24: 
                    case 25: {
                        return true;
                    }
                }
                break;
            }
            case 25: {
                switch (s2) {
                    case 24: 
                    case 25: {
                        return true;
                    }
                }
                break;
            }
            case 7: 
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 45: {
                short s3 = TibrvImplMsgUtil.getElementType(s);
                short s4 = TibrvImplMsgUtil.getElementType(s2);
                if (s4 == 0) {
                    return false;
                }
                return TibrvImplMsgUtil.canConvertType(s3, s4);
            }
        }
        return false;
    }

    static final short getElementType(short s) {
        switch (s) {
            case 7: {
                return 15;
            }
            case 34: {
                return 14;
            }
            case 35: {
                return 15;
            }
            case 36: {
                return 16;
            }
            case 37: {
                return 17;
            }
            case 38: {
                return 18;
            }
            case 39: {
                return 19;
            }
            case 40: {
                return 20;
            }
            case 41: {
                return 21;
            }
            case 44: {
                return 24;
            }
            case 45: {
                return 25;
            }
        }
        return 0;
    }

    static final short getObjectType(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 8;
        }
        if (object instanceof TibrvMsg) {
            return 1;
        }
        if (object instanceof byte[]) {
            return 7;
        }
        if (object instanceof TibrvXml) {
            return 47;
        }
        if (object instanceof TibrvDate) {
            return 3;
        }
        if (object instanceof Date) {
            return 3;
        }
        if (object instanceof TibrvIPAddr) {
            return 27;
        }
        if (object instanceof InetAddress) {
            return 27;
        }
        if (object instanceof TibrvIPPort) {
            return 26;
        }
        if (object instanceof Boolean) {
            return 9;
        }
        if (object instanceof Byte) {
            return 14;
        }
        if (object instanceof Short) {
            return 16;
        }
        if (object instanceof Integer) {
            return 18;
        }
        if (object instanceof Long) {
            return 20;
        }
        if (object instanceof Float) {
            return 24;
        }
        if (object instanceof Double) {
            return 25;
        }
        if (object instanceof short[]) {
            return 36;
        }
        if (object instanceof int[]) {
            return 38;
        }
        if (object instanceof long[]) {
            return 40;
        }
        if (object instanceof float[]) {
            return 44;
        }
        if (object instanceof double[]) {
            return 45;
        }
        return 0;
    }

    static short type6to5(short s) {
        switch (s) {
            case 14: {
                return 11;
            }
            case 15: {
                return 12;
            }
            case 16: {
                return 11;
            }
            case 17: {
                return 12;
            }
            case 18: {
                return 11;
            }
            case 19: {
                return 12;
            }
            case 20: {
                return 11;
            }
            case 21: {
                return 12;
            }
            case 24: {
                return 13;
            }
            case 25: {
                return 13;
            }
            case 26: {
                return 10;
            }
            case 27: {
                return 10;
            }
        }
        return s;
    }

    static short type5to6(short s, int n) throws TibrvException {
        switch (s) {
            case 11: {
                if (n == 1) {
                    return 14;
                }
                if (n == 2) {
                    return 16;
                }
                if (n == 4) {
                    return 18;
                }
                if (n == 8) {
                    return 20;
                }
                throw new TibrvException("Wrong size of integer field", 34);
            }
            case 12: {
                if (n == 1) {
                    return 15;
                }
                if (n == 2) {
                    return 17;
                }
                if (n == 4) {
                    return 19;
                }
                if (n == 8) {
                    return 21;
                }
                throw new TibrvException("Wrong size of unsigned integer field", 34);
            }
            case 13: {
                if (n == 4) {
                    return 24;
                }
                if (n == 8) {
                    return 25;
                }
                throw new TibrvException("Wrong size of real field", 34);
            }
            case 10: {
                if (n == 2) {
                    return 26;
                }
                if (n == 4) {
                    return 27;
                }
                throw new TibrvException("Wrong size of real field", 34);
            }
        }
        return s;
    }

    static int getTypeSize(short s) {
        switch (s) {
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 34: 
            case 35: {
                return 1;
            }
            case 16: 
            case 17: 
            case 26: 
            case 36: 
            case 37: {
                return 2;
            }
            case 18: 
            case 19: 
            case 24: 
            case 27: 
            case 38: 
            case 39: 
            case 44: {
                return 4;
            }
            case 3: 
            case 20: 
            case 21: 
            case 25: 
            case 40: 
            case 41: 
            case 45: {
                return 8;
            }
        }
        return 0;
    }
}

