/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplEvtData;
import com.tibco.tibrv.TibrvImplQGroupJ;
import com.tibco.tibrv.TibrvImplQueue;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvProcessTransport;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvQueueGroup;
import com.tibco.tibrv.TibrvTransport;
import java.util.Vector;

class TibrvImplQueueJ
implements TibrvImplQueue {
    TibrvQueue _parent = null;
    TibrvImplEvtData _head = null;
    TibrvImplEvtData _tail = null;
    int _count = 0;
    boolean _valid = false;
    private int _priority = 1;
    private int _limitPolicy = 0;
    private int _maxEvents = 500;
    private int _discardAmount = 1;

    TibrvImplQueueJ() {
    }

    public void create(TibrvQueue tibrvQueue) {
        this._parent = tibrvQueue;
        this._valid = true;
    }

    public void destroy() throws TibrvException {
        TibrvImplEvtData tibrvImplEvtData = this._head;
        while (tibrvImplEvtData != null) {
            tibrvImplEvtData.event.unschedule();
            tibrvImplEvtData = tibrvImplEvtData.next;
        }
        this._head = null;
        this._tail = null;
        this._count = 0;
        this._valid = false;
    }

    public void setName(String string) {
    }

    public int getCount() {
        return this._count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int n) throws TibrvException {
        Vector vector = null;
        Object object = this._parent._lock;
        synchronized (object) {
            if (this._priority == n) {
                return;
            }
            this._priority = n;
            if (this._parent._groups != null) {
                vector = (Vector)this._parent._groups.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                TibrvQueueGroup tibrvQueueGroup = (TibrvQueueGroup)vector.elementAt(i);
                TibrvImplQGroupJ tibrvImplQGroupJ = (TibrvImplQGroupJ)tibrvQueueGroup._impl;
                if (tibrvImplQGroupJ == null) continue;
                tibrvImplQGroupJ.reorder();
            }
        }
    }

    public int getPriority() {
        return this._priority;
    }

    public void setLimitPolicy(int n, int n2, int n3) {
        if (this._limitPolicy == n && this._maxEvents == n2 && this._discardAmount == n3) {
            return;
        }
        this._limitPolicy = n;
        this._maxEvents = n2;
        this._discardAmount = n3;
        this.executePolicy(false);
    }

    public int getLimitPolicy() {
        return this._limitPolicy;
    }

    public int getMaxEvents() {
        return this._maxEvents;
    }

    public int getDiscardAmount() {
        return this._discardAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() throws TibrvException, InterruptedException {
        TibrvImplEvtData tibrvImplEvtData = null;
        Object object = this._parent._lock;
        synchronized (object) {
            do {
                this._parent.checkValid();
                tibrvImplEvtData = this.removeEvent();
                if (tibrvImplEvtData != null) continue;
                this._parent._lock.wait();
                this._parent.checkValid();
                tibrvImplEvtData = this.removeEvent();
            } while (tibrvImplEvtData == null);
        }
        if (tibrvImplEvtData != null) {
            tibrvImplEvtData.event.invoke(tibrvImplEvtData.data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean timedDispatch(double d) throws TibrvException, InterruptedException {
        TibrvImplEvtData tibrvImplEvtData = null;
        double d2 = d * 1000.0;
        if (d2 >= 9.223372036854776E18) {
            d2 = 9.223372036854776E18;
        }
        long l = (long)d2;
        Object object = this._parent._lock;
        synchronized (object) {
            while ((tibrvImplEvtData = this.removeEvent()) == null) {
                if (d == -1.0) {
                    this._parent._lock.wait();
                    continue;
                }
                if (d == 0.0) {
                    return false;
                }
                if (l <= 1L) {
                    return false;
                }
                long l2 = System.currentTimeMillis();
                this._parent._lock.wait(l);
                long l3 = System.currentTimeMillis();
                l -= l3 - l2;
                l -= 10L;
            }
        }
        if (tibrvImplEvtData != null) {
            tibrvImplEvtData.event.invoke(tibrvImplEvtData.data);
            return true;
        }
        return false;
    }

    public final boolean postEvent(TibrvImplEvtData tibrvImplEvtData, boolean bl) {
        if (!this._valid) {
            return false;
        }
        if (this.executePolicy(true)) {
            return true;
        }
        if (this._head == null) {
            tibrvImplEvtData.prev = null;
            tibrvImplEvtData.next = null;
            this._head = this._tail = tibrvImplEvtData;
        } else if (bl) {
            tibrvImplEvtData.next = this._head;
            tibrvImplEvtData.prev = null;
            this._head.prev = tibrvImplEvtData;
            this._head = tibrvImplEvtData;
        } else {
            tibrvImplEvtData.prev = this._tail;
            tibrvImplEvtData.next = null;
            this._tail.next = tibrvImplEvtData;
            this._tail = tibrvImplEvtData;
        }
        ++this._count;
        this._parent._lock.notifyAll();
        this.notifyGroups();
        return true;
    }

    private boolean executePolicy(boolean bl) {
        int n;
        if (this._limitPolicy == 0) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = n = bl ? 1 : 0;
        if (this._count + n <= this._maxEvents) {
            return false;
        }
        int n3 = this._count - this._maxEvents;
        switch (this._limitPolicy) {
            case 1: {
                bl2 = this.discardLast(n3);
                if (!bl) break;
                bl2 = true;
                bl3 = true;
                break;
            }
            case 2: {
                bl2 = this.discardFirst(n3 + n);
                break;
            }
            case 3: {
                bl2 = this.discardLast(n3 + n);
            }
        }
        if (bl2) {
            try {
                TibrvProcessTransport tibrvProcessTransport = Tibrv.processTransport();
                TibrvMsg tibrvMsg = TibrvTransport.buildAdvisory("WARN", "SYSTEM", "QUEUE.LIMIT.EXCEEDED", this._parent.getName());
                if (tibrvMsg != null && tibrvProcessTransport != null) {
                    tibrvProcessTransport.send(tibrvMsg);
                }
            }
            catch (TibrvException tibrvException) {
                // empty catch block
            }
        }
        return bl3;
    }

    private boolean discardFirst(int n) {
        if (this._head == null || n <= 0 || this._count <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            --this._count;
            this._head = this._head.next;
            if (this._head == null) {
                this._tail = null;
                break;
            }
            this._head.prev = null;
        }
        return true;
    }

    private boolean discardLast(int n) {
        if (this._tail == null || n <= 0 || this._count <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            --this._count;
            this._tail = this._tail.prev;
            if (this._tail == null) {
                this._head = null;
                break;
            }
            this._tail.next = null;
        }
        return true;
    }

    protected TibrvImplEvtData removeEvent() {
        TibrvImplEvtData tibrvImplEvtData = null;
        if (this._head != null) {
            tibrvImplEvtData = this._head;
            --this._count;
            this._head = this._head.next;
            if (this._head == null) {
                this._tail = null;
            } else {
                this._head.prev = null;
            }
        }
        return tibrvImplEvtData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyGroups() {
        Vector vector = this._parent._groups;
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            TibrvQueueGroup tibrvQueueGroup = (TibrvQueueGroup)vector.elementAt(i);
            TibrvImplQGroupJ tibrvImplQGroupJ = (TibrvImplQGroupJ)tibrvQueueGroup._impl;
            if (tibrvImplQGroupJ == null) continue;
            Object object = tibrvImplQGroupJ._waiter;
            synchronized (object) {
                tibrvImplQGroupJ._waiter.notifyAll();
                continue;
            }
        }
    }
}

