/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplConst;
import com.tibco.tibrv.TibrvImplMsgBuffer;
import com.tibco.tibrv.TibrvImplRvaConnect;
import com.tibco.tibrv.TibrvImplTPortRva;
import com.tibco.tibrv.TibrvImplWaiter;
import com.tibco.tibrv.TibrvMsg;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

class TibrvImplRvaDirect
implements TibrvImplRvaConnect,
Runnable,
TibrvImplConst {
    private TibrvImplTPortRva _rvaTport = null;
    Socket _socket = null;
    static Object _socketSync = new Object();
    DataInputStream _inStream = null;
    DataOutputStream _outStream = null;
    Thread _dispatcher = null;
    TibrvImplWaiter _initWaiter = null;

    TibrvImplRvaDirect(TibrvImplTPortRva tibrvImplTPortRva) {
        this._rvaTport = tibrvImplTPortRva;
    }

    private void destroy() {
        this.destroy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(boolean bl) {
        TibrvImplRvaDirect tibrvImplRvaDirect = this;
        synchronized (tibrvImplRvaDirect) {
            try {
                if (this._socket != null) {
                    this._socket.close();
                }
                this._socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this._dispatcher != null) {
                this._dispatcher.interrupt();
            }
            Thread.yield();
            this._dispatcher = null;
            try {
                this._inStream.close();
                this._inStream = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this._outStream.close();
                this._outStream = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TibrvException connect() throws TibrvException {
        Number number;
        Number number2;
        Object object;
        TibrvException tibrvException = null;
        String string = this._rvaTport._hostName;
        int n = this._rvaTport._port;
        try {
            object = _socketSync;
            synchronized (object) {
                this._socket = new Socket(string, n);
                this._socket.setTcpNoDelay(true);
            }
            this._inStream = new DataInputStream(this._socket.getInputStream());
            this._outStream = new DataOutputStream(new BufferedOutputStream(this._socket.getOutputStream(), 1024));
        }
        catch (UnknownHostException unknownHostException) {
            tibrvException = new TibrvException("Could not find host " + string, 1, unknownHostException);
        }
        catch (IOException iOException) {
            tibrvException = new TibrvException("Could not connect to TIB/Rendezvous Agent on " + string + ":" + n, 905, iOException);
        }
        catch (Exception exception) {
            tibrvException = new TibrvException("Could not connect to TIB/Rendezvous Agent on " + string + ":" + n, 905, exception);
        }
        if (tibrvException != null) {
            return tibrvException;
        }
        this._dispatcher = new Thread(this);
        this._dispatcher.start();
        Thread.yield();
        object = TibrvImplTPortRva.buildInitMsg();
        TibrvMsg tibrvMsg = this.getInitReply((TibrvMsg)object, 30000);
        if (tibrvMsg == null) {
            this.destroy();
            throw new TibrvException("No reply to init message", 905);
        }
        if (((Number)tibrvMsg.get("sts")).intValue() != 0) {
            this.destroy();
            throw new TibrvException("RVA error: " + (String)tibrvMsg.get("txt"), 906);
        }
        Object object2 = tibrvMsg.get("sts");
        if (object2 == null || !(object2 instanceof Number)) {
            throw new TibrvException("Invalid response from agent", 906);
        }
        if (((Number)object2).intValue() != 0) {
            throw new TibrvException("rva: " + (String)((TibrvMsg)object).get("txt"), 906);
        }
        Number number3 = (Number)tibrvMsg.get("vmaj");
        if (number3 == null || (number2 = (Number)tibrvMsg.get("vmin")) == null || (number = (Number)tibrvMsg.get("vupd")) == null) {
            this._rvaTport._rvaMajor = 5;
            this._rvaTport._rvaMinor = 0;
            this._rvaTport._rvaUpdate = 0;
        } else {
            this._rvaTport._rvaMajor = number3.intValue();
            this._rvaTport._rvaMinor = number2.intValue();
            this._rvaTport._rvaUpdate = number.intValue();
        }
        if (this._rvaTport._rvaMajor < 6) {
            this.destroy();
            throw new TibrvException("Must use TIB/Rendezvous Agent Version 6.0 or later", 22);
        }
        object2 = tibrvMsg.get("inbox");
        if (object2 == null || !(object2 instanceof String)) {
            this.destroy();
            throw new TibrvException("RVA error: inbox not sent by RVA", 906);
        }
        this._rvaTport._inbox = (String)object2;
        return null;
    }

    public void sendToRva(TibrvMsg tibrvMsg) throws TibrvException {
        TibrvImplRvaDirect tibrvImplRvaDirect = this;
        synchronized (tibrvImplRvaDirect) {
            Exception exception;
            if (this._socket == null) {
                throw new TibrvException(4);
            }
            try {
                TibrvImplMsgBuffer tibrvImplMsgBuffer = (TibrvImplMsgBuffer)tibrvMsg.getAsBytesRaw();
                this._outStream.write(tibrvImplMsgBuffer.bytes, 0, tibrvImplMsgBuffer.offset);
                this._outStream.flush();
                return;
            }
            catch (IOException iOException) {
                this._rvaTport.onDisconnected(iOException);
                exception = iOException;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                exception = exception2;
            }
            throw new TibrvException(907, (Throwable)exception);
        }
    }

    public TibrvMsg getInitReply(TibrvMsg tibrvMsg, int n) throws TibrvException {
        this._initWaiter = new TibrvImplWaiter();
        tibrvMsg.add("mploy", 1);
        tibrvMsg.add("mid", TibrvImplTPortRva.getIdObject(this._initWaiter.getId()));
        try {
            this.sendToRva(tibrvMsg);
        }
        catch (TibrvException tibrvException) {
            this._initWaiter.destroy();
            this._initWaiter = null;
            throw tibrvException;
        }
        TibrvMsg tibrvMsg2 = this._initWaiter.getReply(n);
        this._initWaiter.destroy();
        this._initWaiter = null;
        if (this._socket == null) {
            throw new TibrvException(2);
        }
        return tibrvMsg2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TibrvImplWaiter sendRvaRequest(TibrvMsg tibrvMsg) throws TibrvException {
        TibrvImplRvaDirect tibrvImplRvaDirect = this;
        synchronized (tibrvImplRvaDirect) {
            if (this._socket == null) {
                throw new TibrvException(2);
            }
            TibrvImplWaiter tibrvImplWaiter = new TibrvImplWaiter();
            tibrvMsg.add("mploy", 1);
            tibrvMsg.add("mid", TibrvImplTPortRva.getIdObject(tibrvImplWaiter.getId()));
            try {
                this.sendToRva(tibrvMsg);
            }
            catch (TibrvException tibrvException) {
                tibrvImplWaiter.destroy();
                throw tibrvException;
            }
            return tibrvImplWaiter;
        }
    }

    public final void run() {
        boolean bl = true;
        while (bl) {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                TibrvMsg tibrvMsg = this.readMessage();
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (this._inStream == null || this._socket == null) {
                    return;
                }
                if (tibrvMsg == null) continue;
                this._rvaTport.dispatch(null, tibrvMsg);
            }
            catch (IOException iOException) {
                if (this._initWaiter != null) {
                    this._initWaiter.setReply(null);
                }
                this._rvaTport.onDisconnected(iOException);
                bl = false;
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (TibrvException tibrvException) {
                tibrvException.printStackTrace();
            }
        }
    }

    private TibrvMsg readMessage() throws IOException, TibrvException {
        DataInputStream dataInputStream = this._inStream;
        if (dataInputStream == null || this._socket == null) {
            return null;
        }
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = 8;
        if (n2 != -1722421590) {
            System.out.println("DirectRead: invalid MAGIC in the message");
            throw new IOException();
        }
        if (n - n3 <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, n3, n - n3);
        TibrvMsg.intToBytes(n, byArray, 0);
        TibrvMsg.intToBytes(n2, byArray, 4);
        return new TibrvMsg(byArray);
    }
}

