/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplConst;
import com.tibco.tibrv.TibrvImplHttpPipeThread;
import com.tibco.tibrv.TibrvImplHttpReqThread;
import com.tibco.tibrv.TibrvImplHttpRequest;
import com.tibco.tibrv.TibrvImplRvaConnect;
import com.tibco.tibrv.TibrvImplTPortRva;
import com.tibco.tibrv.TibrvImplWaiter;
import com.tibco.tibrv.TibrvMsg;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

class TibrvImplRvaHttp
implements TibrvImplRvaConnect,
TibrvImplConst {
    protected static final double DEFAULT_PIPE_DELAY = 0.2;
    TibrvImplTPortRva _rvaTport = null;
    boolean valid = false;
    String hostName = null;
    int port = 0;
    int requestTimeout = 30000;
    double pipeDelay = 0.2;
    byte[] clientId = null;
    byte[] clientIndex = null;
    byte[] timestamp = null;
    byte[] rvaip = null;
    TibrvImplHttpPipeThread _pipeThread = null;
    TibrvImplHttpReqThread _requestor = null;
    static final int HTTP_REPLY_OK = 0;
    static final int HTTP_REPLY_EXCEPTION = 1;
    static final int HTTP_REPLY_TIMEOUT = 2;
    static final int MAX_URL_BYTES = 600;
    static final int MIN_PIPE_WAIT = 20000;
    static final int CONNECT_TIMEOUT = 20000;
    private String wrongReply = "Wrong reply from Rendezvous agent";
    private boolean netscapeSecurityFailed = false;
    String codesymbols = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+-";
    static /* synthetic */ Class class$java$lang$String;

    TibrvImplRvaHttp(TibrvImplTPortRva tibrvImplTPortRva) {
        this._rvaTport = tibrvImplTPortRva;
    }

    void setPipeDelay(double d) {
        this.pipeDelay = d;
    }

    double getPipeDelay() {
        return this.pipeDelay;
    }

    public TibrvException connect() throws TibrvException {
        this.hostName = this._rvaTport._hostName;
        this.port = this._rvaTport._port;
        this.valid = true;
        TibrvMsg tibrvMsg = null;
        try {
            TibrvMsg tibrvMsg2 = TibrvImplTPortRva.buildInitMsg();
            tibrvMsg = this.sendRequest(tibrvMsg2, 20000);
        }
        catch (TibrvException tibrvException) {
            this.destroy();
            throw new TibrvException("Could not connect to TIB/Rendezvous Agent on " + this.hostName + ":" + this.port, 905, tibrvException);
        }
        try {
            this.parseInitMsg(tibrvMsg);
        }
        catch (TibrvException tibrvException) {
            this.destroy();
            throw tibrvException;
        }
        this._pipeThread = new TibrvImplHttpPipeThread(this);
        try {
            this._pipeThread.setDaemon(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._pipeThread.start();
        Thread.yield();
        return null;
    }

    void parseInitMsg(TibrvMsg tibrvMsg) throws TibrvException {
        Number number;
        Number number2;
        Object object = tibrvMsg.get("sts");
        if (object == null || !(object instanceof Number)) {
            throw new TibrvException("rva: invalid response", 906);
        }
        if (((Number)object).intValue() != 0) {
            throw new TibrvException("rva: " + (String)tibrvMsg.get("txt"), 906);
        }
        Number number3 = (Number)tibrvMsg.get("vmaj");
        if (number3 == null || (number2 = (Number)tibrvMsg.get("vmin")) == null || (number = (Number)tibrvMsg.get("vupd")) == null) {
            this._rvaTport._rvaMajor = 5;
            this._rvaTport._rvaMinor = 0;
            this._rvaTport._rvaUpdate = 0;
        } else {
            this._rvaTport._rvaMajor = number3.intValue();
            this._rvaTport._rvaMinor = number2.intValue();
            this._rvaTport._rvaUpdate = number.intValue();
        }
        if (this._rvaTport._rvaMajor < 6) {
            this.destroy();
            throw new TibrvException("Must use TIB/Rendezvous Agent Version 6.0 or later", 22);
        }
        object = tibrvMsg.get("inbox");
        if (object == null || !(object instanceof String)) {
            this.destroy();
            throw new TibrvException("RVA error: inbox not sent by RVA", 906);
        }
        this._rvaTport._inbox = (String)object;
        object = tibrvMsg.get("clntid");
        if (object == null || !(object instanceof byte[])) {
            throw new TibrvException(this.wrongReply, 906);
        }
        this.clientId = (byte[])object;
        object = tibrvMsg.get("clntndx");
        if (object == null || !(object instanceof byte[])) {
            throw new TibrvException(this.wrongReply, 906);
        }
        this.clientIndex = (byte[])object;
        object = tibrvMsg.get("clntrvaip");
        if (object == null || !(object instanceof byte[])) {
            throw new TibrvException(this.wrongReply, 906);
        }
        this.rvaip = (byte[])object;
        object = tibrvMsg.get("clnttme");
        if (object == null || !(object instanceof byte[])) {
            throw new TibrvException(this.wrongReply, 906);
        }
        this.timestamp = (byte[])object;
        object = tibrvMsg.get("clntport");
        if (object != null) {
            if (!(object instanceof Number)) {
                throw new TibrvException(this.wrongReply, 906);
            }
            int n = ((Number)object).intValue();
            if (n != 0) {
                this.port = n;
            }
        }
    }

    private final void destroy() {
        this.destroy(true);
    }

    public void destroy(boolean bl) {
        this.cleanup();
    }

    public void sendToRva(TibrvMsg tibrvMsg) throws TibrvException {
        this.enqueue(tibrvMsg);
    }

    public TibrvImplWaiter sendRvaRequest(TibrvMsg tibrvMsg) throws TibrvException {
        return this.enqueueStatus(tibrvMsg);
    }

    Object enqueue(TibrvMsg tibrvMsg) throws TibrvException {
        TibrvMsg tibrvMsg2;
        Thread.yield();
        try {
            tibrvMsg2 = this.sendRequest(tibrvMsg, this.requestTimeout);
        }
        catch (TibrvException tibrvException) {
            String string = (String)tibrvMsg.get("mtype");
            if (string != null && string.equals("T")) {
                return null;
            }
            throw tibrvException;
        }
        Object object = tibrvMsg2.get("sts");
        if (object == null || !(object instanceof Number)) {
            throw new TibrvException(this.wrongReply, 906);
        }
        int n = ((Number)object).intValue();
        object = tibrvMsg2.get("txt");
        if (object == null) {
            throw new TibrvException(this.wrongReply, 906);
        }
        if (n == 0) {
            return object;
        }
        if (object instanceof String) {
            throw new TibrvException((String)object, n);
        }
        throw new TibrvException(this.wrongReply, 906);
    }

    protected final TibrvImplWaiter enqueueStatus(TibrvMsg tibrvMsg) throws TibrvException {
        Thread.yield();
        TibrvImplWaiter tibrvImplWaiter = new TibrvImplWaiter();
        Object object = null;
        try {
            object = this.enqueue(tibrvMsg);
        }
        catch (TibrvException tibrvException) {
            tibrvImplWaiter.setReply(null);
            throw tibrvException;
        }
        TibrvMsg tibrvMsg2 = new TibrvMsg();
        tibrvMsg2.add("ret", object);
        tibrvImplWaiter.setReply(tibrvMsg2);
        return tibrvImplWaiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TibrvMsg sendRequest(TibrvMsg tibrvMsg, int n) throws TibrvException {
        TibrvImplHttpRequest tibrvImplHttpRequest = new TibrvImplHttpRequest(tibrvMsg);
        Object object = this;
        synchronized (object) {
            if (!this.valid) {
                throw new TibrvException(2);
            }
            if (this._requestor == null) {
                this._requestor = new TibrvImplHttpReqThread(this);
                Thread.yield();
            }
            this._requestor.postRequest(tibrvImplHttpRequest);
        }
        object = tibrvImplHttpRequest;
        synchronized (object) {
            try {
                if (!tibrvImplHttpRequest.ready) {
                    tibrvImplHttpRequest.wait(n);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new TibrvException("Request failed", 908, interruptedException);
            }
        }
        if (!this.valid) {
            throw new TibrvException(2);
        }
        if (tibrvImplHttpRequest.error == 0) {
            return tibrvImplHttpRequest.replyMsg;
        }
        if (tibrvImplHttpRequest.error == 1) {
            throw new TibrvException("Request failed", 908, tibrvImplHttpRequest.exception);
        }
        this.closeRequestor();
        throw new TibrvException("Request timed out", 908);
    }

    boolean openHttpPipe(TibrvImplHttpPipeThread tibrvImplHttpPipeThread) {
        int n = 0;
        try {
            block6: {
                do {
                    boolean bl = this.openInputPipeImpl();
                    if (!tibrvImplHttpPipeThread.valid) {
                        return false;
                    }
                    if (bl) break block6;
                } while (++n < 2);
                this.valid = false;
                this._rvaTport.onDisconnected(null);
                return false;
            }
            return true;
        }
        catch (TibrvException tibrvException) {
            this.valid = false;
            return false;
        }
        catch (NullPointerException nullPointerException) {
            this.valid = false;
            return false;
        }
        catch (Exception exception) {
            this.valid = false;
            return false;
        }
    }

    private void connectEx(URLConnection uRLConnection) throws IOException {
        if ((this._rvaTport._httpMode & 0x1000) != 0 && !this.netscapeSecurityFailed) {
            try {
                Class<?> clazz = Class.forName("netscape.security.PrivilegeManager");
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TibrvImplRvaHttp.class$("java.lang.String")) : class$java$lang$String};
                Method method = clazz.getMethod("enablePrivilege", classArray);
                Object[] objectArray = new Object[]{new String("UniversalConnect")};
                method.invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                this.netscapeSecurityFailed = true;
            }
        }
        if (uRLConnection != null) {
            uRLConnection.connect();
        }
    }

    boolean openInputPipeImpl() throws TibrvException {
        long l;
        TibrvMsg tibrvMsg = this.buildRequestMsg();
        tibrvMsg.add("mtype", "E");
        ConnectData connectData = this.buildUrlConnection(tibrvMsg);
        TibrvMsg tibrvMsg2 = null;
        TibrvMsg tibrvMsg3 = null;
        Exception exception = null;
        long l2 = 0L;
        FilterInputStream filterInputStream = null;
        long l3 = System.currentTimeMillis();
        try {
            Object object;
            if (connectData.output != null) {
                connectData.connection.setDoOutput(true);
                object = new DataOutputStream(connectData.connection.getOutputStream());
                ((FilterOutputStream)object).write(connectData.output);
                ((DataOutputStream)object).flush();
                ((FilterOutputStream)object).close();
                Thread.yield();
            }
            this.connectEx(connectData.connection);
            filterInputStream = new DataInputStream(connectData.connection.getInputStream());
            while (true) {
                tibrvMsg2 = this.readMessage((DataInputStream)filterInputStream);
                ++l2;
                if (tibrvMsg3 != null) {
                    this._rvaTport.dispatch(tibrvMsg3, tibrvMsg2);
                    tibrvMsg2 = null;
                    tibrvMsg3 = null;
                    continue;
                }
                object = (String)tibrvMsg2.get("mtype");
                if (((String)object).equals("H")) {
                    tibrvMsg3 = tibrvMsg2;
                    tibrvMsg2 = null;
                    continue;
                }
                if (((String)object).equals("V")) {
                    this._rvaTport.dispatchStatus(tibrvMsg3);
                    continue;
                }
                if (!((String)object).equals("A")) continue;
                this._rvaTport.dispatch(tibrvMsg2, null);
            }
        }
        catch (TibrvException tibrvException) {
            exception = tibrvException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        if (filterInputStream != null) {
            try {
                filterInputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return (l = System.currentTimeMillis()) - l3 >= 20000L || l2 > 0L;
    }

    TibrvMsg executeHttpRequest(TibrvMsg tibrvMsg) throws TibrvException {
        Object object;
        String string = (String)tibrvMsg.get("mtype");
        if (string != null && !string.equals("I") && tibrvMsg.get("clntid") == null) {
            this.addClientInfo(tibrvMsg);
        }
        ConnectData connectData = this.buildUrlConnection(tibrvMsg);
        String string2 = null;
        Exception exception = null;
        if (connectData.output != null) {
            try {
                connectData.connection.setDoOutput(true);
                object = new DataOutputStream(connectData.connection.getOutputStream());
                ((FilterOutputStream)object).write(connectData.output);
                ((DataOutputStream)object).flush();
                ((FilterOutputStream)object).close();
            }
            catch (IOException iOException) {
                throw new TibrvException("Error writing data into " + connectData.toString(), 908);
            }
        }
        object = null;
        try {
            this.connectEx(connectData.connection);
            DataInputStream dataInputStream = new DataInputStream(connectData.connection.getInputStream());
            object = this.readMessage(dataInputStream);
            dataInputStream.close();
        }
        catch (EOFException eOFException) {
            exception = eOFException;
            string2 = "EOFException reading response from the server";
        }
        catch (IOException iOException) {
            exception = iOException;
            string2 = "IOException reading response from  the server";
        }
        catch (TibrvException tibrvException) {
            exception = tibrvException;
            string2 = "Error occurred connecting to the server";
        }
        catch (Exception exception2) {
            exception = exception2;
            string2 = "Error reading TibrvMsg response from the server";
        }
        if (string2 != null) {
            throw new TibrvException(string2, 908, exception);
        }
        return object;
    }

    synchronized void cleanup() {
        this.closeRequestor();
        this.closePipe();
        this.valid = false;
    }

    synchronized void closePipe() {
        if (this._pipeThread != null) {
            this._pipeThread.valid = false;
            this._pipeThread.interrupt();
            this._pipeThread = null;
        }
    }

    synchronized void closeRequestor() {
        if (this._requestor != null) {
            this._requestor.valid = false;
            this._requestor.interrupt();
            this._requestor = null;
        }
    }

    private Vector getNetscapeSecurity() {
        try {
            Class<?> clazz = Class.forName("netscape.security.PrivilegeManager");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TibrvImplRvaHttp.class$("java.lang.String")) : class$java$lang$String};
            Method method = clazz.getMethod("enablePrivilege", classArray);
            Object[] objectArray = new Object[]{new String("UniversalConnect")};
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(method);
            vector.addElement(objectArray);
            return vector;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void ens() {
        try {
            Class<?> clazz = Class.forName("netscape.security.PrivilegeManager");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TibrvImplRvaHttp.class$("java.lang.String")) : class$java$lang$String};
            Method method = clazz.getMethod("enablePrivilege", classArray);
            Object[] objectArray = new Object[]{new String("UniversalConnect")};
            method.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    ConnectData buildUrlConnection(TibrvMsg tibrvMsg) throws TibrvException {
        ConnectData connectData = new ConnectData();
        String string = "http://" + this.hostName + ":" + this.port + "/";
        byte[] byArray = tibrvMsg.getAsBytes();
        String string2 = null;
        Exception exception = null;
        if (byArray.length < 600) {
            string2 = new String(this.bytesToChars(byArray));
            string = string + "?";
            string = string + string2;
            connectData.output = null;
        } else {
            connectData.output = byArray;
        }
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDefaultUseCaches(false);
            uRLConnection.setUseCaches(false);
            uRLConnection.setAllowUserInteraction(false);
            uRLConnection.setDoInput(true);
            connectData.connection = uRLConnection;
            return connectData;
        }
        catch (MalformedURLException malformedURLException) {
            exception = malformedURLException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        throw new TibrvException("Could not connect to " + connectData.toString(), 908, exception);
    }

    TibrvMsg readMessage(DataInputStream dataInputStream) throws EOFException, IOException, TibrvException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = 8;
        if (n2 != -1722421590) {
            System.err.println("HttpRead: invalid MAGIC in the message");
            throw new IOException();
        }
        if (n - n3 <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, n3, n - n3);
        TibrvMsg.intToBytes(n, byArray, 0);
        TibrvMsg.intToBytes(n2, byArray, 4);
        TibrvMsg tibrvMsg = new TibrvMsg(byArray);
        return tibrvMsg;
    }

    TibrvMsg buildRequestMsg() throws TibrvException {
        TibrvMsg tibrvMsg = new TibrvMsg();
        this.addClientInfo(tibrvMsg);
        return tibrvMsg;
    }

    void addClientInfo(TibrvMsg tibrvMsg) throws TibrvException {
        tibrvMsg.add("clntid", this.clientId);
        tibrvMsg.add("clntndx", this.clientIndex);
        tibrvMsg.add("clntrvaip", this.rvaip);
        tibrvMsg.add("clnttme", this.timestamp);
    }

    char[] bytesToChars(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = n2 % 3;
        int n4 = n3 == 0 ? 0 : 3 - n3;
        int n5 = (n2 + n4) / 3 * 4;
        int n6 = n2 / 3;
        boolean bl = n3 != 0;
        byte[] byArray2 = null;
        char[] cArray = new char[n5 + 1];
        cArray[0] = this.codesymbols.charAt(n4);
        for (n = 0; n < n6; ++n) {
            int n7 = 1 + 4 * n;
            this.encode(cArray, n7, byArray, n * 3);
        }
        if (bl) {
            byArray2 = new byte[3];
            for (n = 0; n < n3; ++n) {
                byArray2[n] = byArray[n6 * 3 + n];
            }
            for (n = n3; n < 3; ++n) {
                byArray2[n] = 0;
            }
            this.encode(cArray, 1 + n6 * 4, byArray2, 0);
        }
        return cArray;
    }

    void encode(char[] cArray, int n, byte[] byArray, int n2) {
        int n3 = n2;
        int n4 = byArray[n3] >> 2 & 0x3F;
        cArray[n] = this.codesymbols.charAt(n4);
        n4 = byArray[n3] << 4 & 0x30 | byArray[n3 + 1] >> 4 & 0xF;
        cArray[n + 1] = this.codesymbols.charAt(n4);
        n4 = byArray[n3 + 1] << 2 & 0x3C | byArray[n3 + 2] >> 6 & 3;
        cArray[n + 2] = this.codesymbols.charAt(n4);
        n4 = byArray[n3 + 2] & 0x3F;
        cArray[n + 3] = this.codesymbols.charAt(n4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConnectData {
        URLConnection connection = null;
        byte[] output = null;

        ConnectData() {
        }

        public String toString() {
            if (this.connection == null) {
                return "null";
            }
            String string = this.connection.getURL().toString();
            int n = string.indexOf("?");
            if (n >= 0) {
                return string.substring(0, n);
            }
            return string;
        }
    }
}

