/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImplMsgBuffer;
import com.tibco.tibrv.TibrvImplQueue;
import com.tibco.tibrv.TibrvImplQueueC;
import com.tibco.tibrv.TibrvImplTPort;
import com.tibco.tibrv.TibrvListener;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvTransport;

class TibrvImplTPortC
implements TibrvImplTPort {
    protected int _handle = 0;
    private TibrvTransport _parent = null;
    private String _type = null;

    protected TibrvImplTPortC() {
    }

    public void create(TibrvTransport tibrvTransport, Object[] objectArray) throws TibrvException {
        this._parent = tibrvTransport;
        this._type = (String)objectArray[3];
        if (this._type != null && (this._type.equals("rvd") || this._type.equals("proc"))) {
            this._handle = this.natCreate(TibrvMsg.defStringToBytes((String)objectArray[0]), TibrvMsg.defStringToBytes((String)objectArray[1]), TibrvMsg.defStringToBytes((String)objectArray[2]), TibrvMsg.defStringToBytes((String)objectArray[3]), TibrvMsg.defStringToBytes((String)objectArray[4]));
        }
    }

    public boolean isRva() {
        return false;
    }

    public void destroy() {
        int n = this._handle;
        this._handle = 0;
        try {
            this.natDestroy(n);
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    public void setDescription(String string) throws TibrvException {
        this.natSetDescription(this._handle, TibrvMsg.defStringToBytes(string));
    }

    public void send(TibrvMsg tibrvMsg) throws TibrvException {
        byte[] byArray = tibrvMsg.getAsBytes();
        this.natSend(this._handle, byArray, byArray.length, tibrvMsg.getSendSubjectAsBytes(), tibrvMsg.getReplySubjectAsBytes());
    }

    public TibrvMsg sendRequest(TibrvMsg tibrvMsg, double d) throws TibrvException {
        byte[] byArray = tibrvMsg.getAsBytes();
        return this.natSendRequest(this._handle, byArray, byArray.length, tibrvMsg.getSendSubjectAsBytes(), d);
    }

    public void sendReply(TibrvMsg tibrvMsg, TibrvMsg tibrvMsg2) throws TibrvException {
        tibrvMsg.setSendSubject(tibrvMsg2.getReplySubject());
        this.send(tibrvMsg);
    }

    public String createInbox() throws TibrvException {
        byte[] byArray = this.natCreateInbox(this._handle);
        return TibrvImplMsgBuffer.stringFromBytes(byArray, 0, byArray.length, TibrvMsg.getStringEncoding());
    }

    public void createListener(TibrvListener tibrvListener) throws TibrvException {
        try {
            TibrvImplQueue tibrvImplQueue = tibrvListener.getQueue()._impl;
            if (tibrvListener.getQueue().isValid()) {
                this.natCreateListener(this._handle, tibrvListener, ((TibrvImplQueueC)tibrvImplQueue)._handle, TibrvMsg.defStringToBytes(tibrvListener.getSubject()));
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new TibrvException(62);
    }

    public void destroyListener(TibrvListener tibrvListener, int n) {
        try {
            this.natDestroyListener(this._handle, tibrvListener, n);
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        if (this._handle != 0 && this._type != null && this._type.equals("rvd")) {
            try {
                this.natDestroy(this._handle);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setBatchMode(int n) throws TibrvException {
        if (this._type != null && this._type.equals("rvd")) {
            this.natSetBatchMode(this._handle, n);
        }
    }

    public void createConnectVc(String string, TibrvTransport tibrvTransport) throws TibrvException {
        if (this._type != null && this._type.equals("vc")) {
            TibrvImplTPortC tibrvImplTPortC = (TibrvImplTPortC)tibrvTransport._impl;
            this._handle = this.natCreateConnectVc(TibrvMsg.defStringToBytes(string), tibrvImplTPortC._handle);
        }
    }

    public String createAcceptVc(TibrvTransport tibrvTransport) throws TibrvException {
        if (this._type != null && this._type.equals("vc")) {
            TibrvImplTPortC tibrvImplTPortC = (TibrvImplTPortC)tibrvTransport._impl;
            byte[] byArray = this.natCreateAcceptVc(tibrvImplTPortC._handle);
            this._handle = byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
            return TibrvImplMsgBuffer.stringFromBytes(byArray, 4, byArray.length - 4, TibrvMsg.getStringEncoding());
        }
        return null;
    }

    public void waitForVcConnection(double d) throws TibrvException {
        if (this._type != null && this._type.equals("vc")) {
            this.natWaitForVcConnection(this._handle, d);
        }
    }

    private native int natCreate(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5) throws TibrvException;

    private native void natDestroy(int var1) throws TibrvException;

    private native void natSetDescription(int var1, byte[] var2) throws TibrvException;

    private native void natSend(int var1, byte[] var2, int var3, byte[] var4, byte[] var5) throws TibrvException;

    private native TibrvMsg natSendRequest(int var1, byte[] var2, int var3, byte[] var4, double var5) throws TibrvException;

    private native byte[] natCreateInbox(int var1) throws TibrvException;

    private native void natCreateListener(int var1, TibrvListener var2, int var3, byte[] var4) throws TibrvException;

    private native void natDestroyListener(int var1, TibrvListener var2, int var3) throws TibrvException;

    private native void natSetBatchMode(int var1, int var2) throws TibrvException;

    private native int natCreateConnectVc(byte[] var1, int var2) throws TibrvException;

    private native byte[] natCreateAcceptVc(int var1) throws TibrvException;

    private native void natWaitForVcConnection(int var1, double var2) throws TibrvException;
}

