/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvTimer;
import java.util.Vector;

class TibrvImplTimerRun
implements Runnable {
    private Vector timers = new Vector();
    private Thread thread = null;
    private TibrvTimer[] _fired = new TibrvTimer[128];

    TibrvImplTimerRun() {
    }

    static final long toMillis(double d) {
        if (d == 0.0) {
            return 0L;
        }
        double d2 = (d + 5.0E-4) * 1000.0;
        if (d2 >= 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        return (long)d2;
    }

    protected synchronized void start() {
        this.thread = new Thread(this);
        try {
            this.thread.setDaemon(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.thread.start();
    }

    protected synchronized void stop() {
        this.timers.removeAllElements();
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    private double getTarget(TibrvTimer tibrvTimer, long l) {
        double d = tibrvTimer._interval * 1000.0;
        return (double)l + d;
    }

    protected final synchronized void addTimer(TibrvTimer tibrvTimer) {
        tibrvTimer._target = this.getTarget(tibrvTimer, System.currentTimeMillis());
        this._addTimer(tibrvTimer);
    }

    private final synchronized void _addTimer(TibrvTimer tibrvTimer) {
        int n;
        int n2 = 0;
        int n3 = this.timers.size() - 1;
        if (n3 >= 0) {
            while (n2 < n3) {
                int n4 = (n2 + n3) / 2;
                if (((TibrvTimer)this.timers.elementAt((int)n4))._target > tibrvTimer._target) {
                    n3 = n4 - 1;
                    continue;
                }
                n2 = n4 + 1;
            }
            n = ((TibrvTimer)this.timers.elementAt((int)n2))._target <= tibrvTimer._target ? n2 + 1 : n2;
        } else {
            n = 0;
        }
        this.timers.insertElementAt(tibrvTimer, n);
        this.notifyAll();
    }

    protected final synchronized void removeTimer(TibrvTimer tibrvTimer) {
        this.timers.removeElement(tibrvTimer);
    }

    public final void run() {
        while (true) {
            try {
                while (true) {
                    this.doRun();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doRun() throws InterruptedException {
        int n = 0;
        TibrvImplTimerRun tibrvImplTimerRun = this;
        synchronized (tibrvImplTimerRun) {
            long l;
            if (this.timers.isEmpty()) {
                l = Long.MAX_VALUE;
            } else {
                double d = ((TibrvTimer)this.timers.firstElement())._target - (double)System.currentTimeMillis();
                l = d >= 9.223372036854776E18 ? Long.MAX_VALUE : (long)d;
                if (l < 1L) {
                    l = 1L;
                }
            }
            this.wait(l);
            if (this._fired.length < this.timers.size()) {
                this._fired = new TibrvTimer[this.timers.size() + 64];
            } else if (this._fired.length > 128 && this.timers.size() * 2 >= 128 && this._fired.length > this.timers.size() * 2) {
                this._fired = new TibrvTimer[this.timers.size() * 2];
            }
            n = 0;
            double d = System.currentTimeMillis();
            while (!this.timers.isEmpty()) {
                TibrvTimer tibrvTimer;
                TibrvTimer tibrvTimer2 = (TibrvTimer)this.timers.firstElement();
                if (!(tibrvTimer._target <= d)) break;
                this.timers.removeElementAt(0);
                this._fired[n] = tibrvTimer2;
                ++n;
            }
        }
        for (int i = 0; i < n; ++i) {
            this._fired[i].fire();
        }
    }

    final synchronized void resetInterval(TibrvTimer tibrvTimer, double d) throws TibrvException {
        int n = this.timers.indexOf(tibrvTimer);
        if (n < 0) {
            tibrvTimer._interval = d;
            return;
        }
        this.timers.removeElementAt(n);
        tibrvTimer._interval = d;
        this.addTimer(tibrvTimer);
    }
}

