/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvEvent;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplTPort;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvMsgCallback;
import com.tibco.tibrv.TibrvNetTransport;
import com.tibco.tibrv.TibrvProcessTransport;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvRvdTransport;
import com.tibco.tibrv.TibrvTransport;

public class TibrvListener
extends TibrvEvent {
    String _subject = null;
    TibrvTransport _transport = null;
    Long _listenId = null;
    private TibrvListener _shadow = null;

    protected TibrvListener() throws TibrvException {
    }

    public TibrvListener(TibrvQueue tibrvQueue, TibrvMsgCallback tibrvMsgCallback, TibrvTransport tibrvTransport, String string, Object object) throws TibrvException {
        this.init(tibrvQueue, tibrvMsgCallback, tibrvTransport, string, object);
    }

    private void init(TibrvQueue tibrvQueue, Object object, TibrvTransport tibrvTransport, String string, Object object2) throws TibrvException {
        if (tibrvQueue == null) {
            throw new IllegalArgumentException("queue is null");
        }
        if (object == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (tibrvTransport == null) {
            throw new IllegalArgumentException("transport is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("subject is null");
        }
        if (!tibrvQueue.isValid()) {
            throw new TibrvException(62);
        }
        TibrvImpl tibrvImpl = Tibrv._impl;
        TibrvImplTPort tibrvImplTPort = tibrvTransport._impl;
        Tibrv.checkValid();
        if (tibrvImpl == null) {
            throw new TibrvException(4);
        }
        if (!tibrvTransport.isValid() || tibrvImplTPort == null) {
            throw new TibrvException(2);
        }
        this._queue = tibrvQueue;
        this._callback = object;
        this._transport = tibrvTransport;
        this._subject = string;
        this._closure = object2;
        tibrvImplTPort.createListener(this);
        if (tibrvTransport instanceof TibrvNetTransport && !(tibrvTransport instanceof TibrvRvdTransport) && Tibrv.isNativeImpl()) {
            this.createShadowListener();
        }
        tibrvImpl.register(this);
        this._valid = true;
    }

    private void createShadowListener() throws TibrvException {
        TibrvProcessTransport tibrvProcessTransport = Tibrv.processTransport();
        if (tibrvProcessTransport == null) {
            throw new TibrvException(4);
        }
        String string = tibrvProcessTransport.createInbox();
        this._shadow = new TibrvListener(this._queue, new SL(this), tibrvProcessTransport, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyShadowListener() {
        Object object = this._lock;
        synchronized (object) {
            if (this._shadow != null) {
                this._shadow.destroy();
                this._shadow = null;
            }
        }
    }

    public void destroy() {
        this.destroyImpl(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void destroyImpl(int n) {
        boolean bl = false;
        TibrvImpl tibrvImpl = null;
        TibrvTransport tibrvTransport = null;
        TibrvImplTPort tibrvImplTPort = null;
        Object object = this._lock;
        synchronized (object) {
            tibrvImpl = Tibrv._impl;
            tibrvTransport = this._transport;
            if (tibrvTransport != null && (tibrvImplTPort = tibrvTransport._impl) == null) {
                tibrvImplTPort = tibrvTransport._destroyImpl;
            }
            if (!Tibrv.isValid()) {
                return;
            }
            if (tibrvImpl == null) {
                return;
            }
            if (!this._valid) {
                return;
            }
            this.destroyShadowListener();
            this._valid = false;
            this._queue = null;
            this._transport = null;
            this._callback = null;
            bl = true;
        }
        if (bl) {
            if (tibrvImpl != null) {
                tibrvImpl.unregister(this);
            }
            if (tibrvImplTPort != null) {
                tibrvImplTPort.destroyListener(this, n);
            }
            super.destroy();
        }
    }

    public TibrvTransport getTransport() {
        return this._transport;
    }

    public String getSubject() {
        return this._subject;
    }

    public String toString() {
        return "TibrvListener[subject=" + this._subject + "]";
    }

    protected TibrvTransport getDependTport() {
        return this._transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fire(Object object, boolean bl) {
        if (Tibrv.isNativeImpl() && object instanceof TibrvMsg) {
            TibrvMsg tibrvMsg = (TibrvMsg)object;
            TibrvQueue tibrvQueue = this._queue;
            TibrvProcessTransport tibrvProcessTransport = Tibrv.processTransport();
            Object object2 = this._lock;
            synchronized (object2) {
                if (!this._valid || tibrvQueue == null || this._shadow == null || tibrvProcessTransport == null) {
                    return false;
                }
                try {
                    TibrvMsg tibrvMsg2 = new TibrvMsg();
                    String string = tibrvMsg.getReplySubject();
                    tibrvMsg2.add("subject", tibrvMsg.getSendSubject());
                    if (string != null) {
                        tibrvMsg2.add("reply", string);
                    }
                    tibrvMsg2.add("msg", tibrvMsg);
                    tibrvMsg2.setSendSubject(this._shadow.getSubject());
                    tibrvProcessTransport.send(tibrvMsg2);
                }
                catch (TibrvException tibrvException) {
                    return false;
                }
            }
            return true;
        }
        return super.fire(object, bl);
    }

    class SL
    implements TibrvMsgCallback {
        private TibrvListener _listener;

        SL(TibrvListener tibrvListener2) {
            this._listener = tibrvListener2;
        }

        public void onMsg(TibrvListener tibrvListener, TibrvMsg tibrvMsg) {
            try {
                String string = (String)tibrvMsg.get("subject");
                String string2 = (String)tibrvMsg.get("reply");
                TibrvMsg tibrvMsg2 = (TibrvMsg)tibrvMsg.get("msg");
                tibrvMsg2.setSendSubject(string);
                tibrvMsg2.setReplySubject(string2);
                this._listener.invoke(tibrvMsg2);
            }
            catch (TibrvException tibrvException) {
                tibrvException.printStackTrace();
                return;
            }
        }
    }
}

