/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvDispatchable;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplQGroup;
import com.tibco.tibrv.TibrvQueue;
import java.util.Enumeration;
import java.util.Vector;

public class TibrvQueueGroup
implements TibrvDispatchable {
    protected Object _lock = new Object();
    private boolean _valid = false;
    protected TibrvImplQGroup _impl = null;
    protected Vector _queues = new Vector();
    private static final String _implName = "TibrvImplQGroup";

    public TibrvQueueGroup() throws TibrvException {
        this.init();
    }

    public boolean isValid() {
        return this._valid;
    }

    public void destroy() {
        this.destroyImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyImpl() {
        try {
            Object object = this._lock;
            synchronized (object) {
                if (!this._valid) {
                    return;
                }
                this._lock.notifyAll();
                TibrvImpl tibrvImpl = Tibrv._impl;
                Tibrv.checkValid();
                TibrvImplQGroup tibrvImplQGroup = this._impl;
                this._impl = null;
                this._valid = false;
                for (int i = 0; i < this._queues.size(); ++i) {
                    TibrvQueue tibrvQueue = (TibrvQueue)this._queues.elementAt(i);
                    tibrvQueue.unregister(this);
                }
                this._queues.removeAllElements();
                tibrvImpl.unregister(this);
                if (tibrvImplQGroup != null) {
                    tibrvImplQGroup.destroy();
                }
            }
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TibrvQueue tibrvQueue) throws TibrvException {
        if (tibrvQueue == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        tibrvQueue.checkValid();
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            if (this._queues.contains(tibrvQueue)) {
                return;
            }
            this._impl.addQueue(tibrvQueue);
            tibrvQueue.register(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TibrvQueue tibrvQueue) throws TibrvException {
        if (tibrvQueue == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            if (!this._queues.contains(tibrvQueue)) {
                throw new TibrvException(62);
            }
            this._impl.removeQueue(tibrvQueue);
            tibrvQueue.unregister(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(TibrvQueue tibrvQueue) {
        Object object = this._lock;
        synchronized (object) {
            if (this._impl == null || this._queues == null) {
                return false;
            }
            return this._queues.contains(tibrvQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        Object object = this._lock;
        synchronized (object) {
            if (this._impl == null || this._queues == null) {
                return null;
            }
            return this._queues.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Object object = this._lock;
        synchronized (object) {
            if (this._impl == null || this._queues == null) {
                return 0;
            }
            return this._queues.size();
        }
    }

    public void dispatch() throws TibrvException, InterruptedException {
        TibrvImplQGroup tibrvImplQGroup = this._impl;
        this.checkValid();
        if (tibrvImplQGroup == null) {
            throw new TibrvException(63);
        }
        tibrvImplQGroup.dispatch();
    }

    public boolean timedDispatch(double d) throws TibrvException, InterruptedException {
        if (d != -1.0 && d < 0.0) {
            throw new IllegalArgumentException("Invalid timeout");
        }
        TibrvImplQGroup tibrvImplQGroup = this._impl;
        this.checkValid();
        if (tibrvImplQGroup != null) {
            return tibrvImplQGroup.timedDispatch(d);
        }
        throw new TibrvException(63);
    }

    public boolean poll() throws TibrvException, InterruptedException {
        return this.timedDispatch(0.0);
    }

    public String toString() {
        return "TibrvQueueGroup";
    }

    private void init() throws TibrvException {
        TibrvImpl tibrvImpl = Tibrv._impl;
        Tibrv.checkValid();
        this._impl = (TibrvImplQGroup)Tibrv.createObjectImpl(_implName);
        this._impl.create(this);
        this._valid = true;
        tibrvImpl.register(this);
    }

    protected void checkValid() throws TibrvException {
        if (!this._valid || this._impl == null) {
            throw new TibrvException(63);
        }
    }
}

