/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplTPortRva;
import com.tibco.tibrv.TibrvNetTransport;

public class TibrvRvaTransport
extends TibrvNetTransport {
    private static final int HTTP_TUNNEL_DISABLE_OLD = -1;
    public static final int HTTP_TUNNEL_ENABLE = 0;
    public static final int HTTP_TUNNEL_ENFORCE = 1;
    public static final int HTTP_TUNNEL_DISABLE = 2;
    public static final int USE_NETSCAPE_SECURITY = 4096;
    public static final int DEFAULT_RVA_PORT = 7600;
    private String _hostName = null;
    private int _port = 0;
    private int _tunnelMode = 0;

    public TibrvRvaTransport() throws TibrvException {
        this.init(null, 7600, 2);
    }

    public TibrvRvaTransport(String string) throws TibrvException {
        this.init(string, 7600, 2);
    }

    public TibrvRvaTransport(String string, int n) throws TibrvException {
        this.init(string, n, 2);
    }

    public TibrvRvaTransport(String string, int n, boolean bl) throws TibrvException {
        int n2 = bl ? 0 : 2;
        this.init(string, n, n2);
    }

    public TibrvRvaTransport(String string, int n, int n2) throws TibrvException {
        this.init(string, n, n2);
    }

    private void init(String string, int n, int n2) throws TibrvException {
        int n3;
        if (n2 == -1) {
            n2 = 2;
        }
        if ((n3 = n2 & 0xFFFFEFFF) != 0 && n3 != 2 && n3 != 1) {
            throw new IllegalArgumentException("Invalid tunnel mode value");
        }
        this._hostName = string;
        this._port = n;
        this._tunnelMode = n2;
        if (this._port == 0) {
            this._port = 7600;
        }
        TibrvImpl tibrvImpl = Tibrv._impl;
        Tibrv.checkValid();
        if (tibrvImpl == null) {
            throw new TibrvException(4);
        }
        this._impl = new TibrvImplTPortRva();
        Object[] objectArray = new Object[]{this._hostName, new Integer(this._port), new Integer(n2)};
        this._impl.create(this, objectArray);
        this._valid = true;
        tibrvImpl.register(this);
    }

    public void destroy() {
        this.destroyImpl();
    }

    public String getHostName() {
        return this._hostName;
    }

    public int getPort() {
        return this._port;
    }

    public boolean isHttpTunneling() {
        TibrvImplTPortRva tibrvImplTPortRva = (TibrvImplTPortRva)this._impl;
        if (tibrvImplTPortRva != null) {
            return tibrvImplTPortRva.isHttpTunneling();
        }
        return false;
    }

    public void setHttpReconnectDelay(double d) {
        TibrvImplTPortRva tibrvImplTPortRva = (TibrvImplTPortRva)this._impl;
        if (tibrvImplTPortRva != null) {
            tibrvImplTPortRva.setPipeDelay(d);
        }
    }

    public double getHttpReconnectDelay() {
        TibrvImplTPortRva tibrvImplTPortRva = (TibrvImplTPortRva)this._impl;
        if (tibrvImplTPortRva != null) {
            return tibrvImplTPortRva.getPipeDelay();
        }
        return 0.2;
    }

    public String toString() {
        return "TibrvRvaTransport[host=" + this._hostName + ",port=" + this._port + "]";
    }
}

