/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvEvent;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvQueue;
import com.tibco.tibrv.TibrvTimerCallback;

public class TibrvTimer
extends TibrvEvent {
    double _interval = 0.0;
    double _target = 0.0;

    public TibrvTimer(TibrvQueue tibrvQueue, TibrvTimerCallback tibrvTimerCallback, double d, Object object) throws TibrvException {
        this.init(tibrvQueue, tibrvTimerCallback, d, object);
    }

    private void init(TibrvQueue tibrvQueue, Object object, double d, Object object2) throws TibrvException {
        if (tibrvQueue == null) {
            throw new IllegalArgumentException("queue is null");
        }
        if (object == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("negative interval");
        }
        TibrvImpl tibrvImpl = Tibrv._impl;
        if (tibrvImpl == null) {
            throw new TibrvException(4);
        }
        this._queue = tibrvQueue;
        this._callback = object;
        this._interval = d;
        this._closure = object2;
        tibrvImpl.createTimer(this);
        tibrvImpl.register(this);
        this._valid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        boolean bl = false;
        TibrvImpl tibrvImpl = null;
        Object object = this._lock;
        synchronized (object) {
            tibrvImpl = Tibrv._impl;
            if (!Tibrv.isValid()) {
                return;
            }
            if (!this._valid) {
                return;
            }
            this._valid = false;
            this._queue = null;
            this._callback = null;
            bl = true;
        }
        if (bl) {
            if (tibrvImpl != null) {
                tibrvImpl.unregister(this);
                tibrvImpl.destroyTimer(this);
            }
            super.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetInterval(double d) throws TibrvException {
        if (d < 0.0) {
            throw new IllegalArgumentException("negative interval");
        }
        TibrvImpl tibrvImpl = null;
        Object object = this._lock;
        synchronized (object) {
            tibrvImpl = Tibrv._impl;
            Tibrv.checkValid();
            if (!this._valid) {
                throw new TibrvException(60);
            }
            tibrvImpl.resetInterval(this, d);
            this._interval = d;
        }
    }

    public double getInterval() {
        return this._interval;
    }

    public String toString() {
        return "TibrvTimer[interval=" + this._interval + " seconds]";
    }
}

