/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.tibrv;

import com.tibco.tibrv.Tibrv;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvImpl;
import com.tibco.tibrv.TibrvImplTPort;
import com.tibco.tibrv.TibrvMsg;

public abstract class TibrvTransport {
    TibrvImplTPort _impl = null;
    Object _lock = new Object();
    boolean _valid = false;
    boolean _destroying = false;
    TibrvImplTPort _destroyImpl = null;
    String _description = "";

    protected TibrvTransport() throws TibrvException {
        Tibrv.checkValid();
    }

    protected TibrvTransport getDependTport() {
        return null;
    }

    public boolean isValid() {
        return this._valid && this._impl != null;
    }

    public abstract void destroy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyImpl() {
        try {
            TibrvImpl tibrvImpl = null;
            TibrvImplTPort tibrvImplTPort = null;
            boolean bl = false;
            Object object = this._lock;
            synchronized (object) {
                tibrvImpl = Tibrv._impl;
                Tibrv.checkValid();
                this.checkValid();
                this._destroying = true;
                this._destroyImpl = tibrvImplTPort = this._impl;
                this._impl = null;
                this._valid = false;
                bl = true;
            }
            if (bl) {
                tibrvImplTPort.destroy();
                if (tibrvImpl != null) {
                    tibrvImpl.destroyTransportDependents(this);
                    tibrvImpl.unregister(this);
                }
                this._destroyImpl = null;
            }
            this._destroying = false;
        }
        catch (TibrvException tibrvException) {
            // empty catch block
        }
    }

    static TibrvMsg buildAdvisory(String string, String string2, String string3, String string4) {
        TibrvMsg tibrvMsg = new TibrvMsg();
        try {
            String string5 = "_RV." + string + "." + string2 + "." + string3;
            tibrvMsg.setSendSubject(string5);
            tibrvMsg.add("ADV_CLASS", string);
            tibrvMsg.add("ADV_SOURCE", string2);
            tibrvMsg.add("ADV_NAME", string3);
            if (string4 != null) {
                tibrvMsg.add("ADV_DESC", string4);
            }
            return tibrvMsg;
        }
        catch (TibrvException tibrvException) {
            return null;
        }
    }

    public String getDescription() {
        return this._description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String string) throws TibrvException {
        String string2 = "";
        string2 = string == null ? "" : string;
        if (!string2.equals(this._description)) {
            TibrvImplTPort tibrvImplTPort;
            this._description = string2;
            Object object = this._lock;
            synchronized (object) {
                this.checkValid();
                tibrvImplTPort = this._impl;
            }
            tibrvImplTPort.setDescription(this._description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(TibrvMsg tibrvMsg) throws TibrvException {
        TibrvImplTPort tibrvImplTPort;
        if (tibrvMsg == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            tibrvImplTPort = this._impl;
        }
        tibrvImplTPort.send(tibrvMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TibrvMsg sendRequest(TibrvMsg tibrvMsg, double d) throws TibrvException {
        TibrvImplTPort tibrvImplTPort;
        if (tibrvMsg == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        if (d < 0.0 && d != -1.0) {
            throw new IllegalArgumentException("Invalid timeout");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            tibrvImplTPort = this._impl;
        }
        return tibrvImplTPort.sendRequest(tibrvMsg, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReply(TibrvMsg tibrvMsg, TibrvMsg tibrvMsg2) throws TibrvException {
        TibrvImplTPort tibrvImplTPort;
        if (tibrvMsg == null || tibrvMsg2 == null) {
            throw new IllegalArgumentException("Null parameter");
        }
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            tibrvImplTPort = this._impl;
        }
        tibrvImplTPort.sendReply(tibrvMsg, tibrvMsg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createInbox() throws TibrvException {
        TibrvImplTPort tibrvImplTPort;
        Object object = this._lock;
        synchronized (object) {
            this.checkValid();
            tibrvImplTPort = this._impl;
        }
        return tibrvImplTPort.createInbox();
    }

    protected void checkValid() throws TibrvException {
        if (!this._valid || this._impl == null) {
            throw new TibrvException(2);
        }
    }

    protected void checkValidOrDestroying() throws TibrvException {
        if (!this._valid || this._destroying || this._impl == null) {
            throw new TibrvException(2);
        }
    }
}

